<?php

/**
 * @file
 * Defines the default currency list of active currencies from ISO 4217.
 * The currency symbols and formatting rules are provided by CLDR.
 */


/**
 * Implements hook_commerce_currency_info().
 */
function commerce_commerce_currency_info() {
  return array(
    'AED' => array(
      'code' => 'AED',
      'numeric_code' => '784',
      'symbol' => 'د.إ.‏',
      'name' => t('United Arab Emirates Dirham'),
      'minor_unit' => t('Fils'),
      'major_unit' => t('Dirham'),
    ),
    'AFN' => array(
      'code' => 'AFN',
      'numeric_code' => '971',
      'symbol' => '؋',
      'name' => t('Afghan Afghani'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Pul'),
      'major_unit' => t('Afghani'),
      'decimals' => 0,
    ),
    'ALL' => array(
      'code' => 'ALL',
      'numeric_code' => '008',
      'symbol' => 'Lekë',
      'name' => t('Albanian Lek'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'major_unit' => t('Lek'),
      'decimals' => 0,
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
    ),
    'AMD' => array(
      'code' => 'AMD',
      'numeric_code' => '051',
      'symbol' => '֏',
      'name' => t('Armenian Dram'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'major_unit' => t('Dram'),
      'decimals' => 0,
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
    ),
    'ANG' => array(
      'code' => 'ANG',
      'numeric_code' => '532',
      'symbol' => 'ANG',
      'name' => t('Netherlands Antillean Guilder'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Guilder'),
    ),
    'AOA' => array(
      'code' => 'AOA',
      'numeric_code' => '973',
      'symbol' => 'Kz',
      'name' => t('Angolan Kwanza'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cêntimo'),
      'major_unit' => t('Kwanza'),
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
    ),
    'ARS' => array(
      'code' => 'ARS',
      'numeric_code' => '032',
      'symbol' => '$',
      'name' => t('Argentine Peso'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Peso'),
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'AUD' => array(
      'code' => 'AUD',
      'numeric_code' => '036',
      'symbol' => '$',
      'name' => t('Australian Dollar'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'AWG' => array(
      'code' => 'AWG',
      'numeric_code' => '533',
      'symbol' => 'Afl.',
      'name' => t('Aruban Florin'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Guilder'),
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'AZN' => array(
      'code' => 'AZN',
      'numeric_code' => '944',
      'symbol' => '₼',
      'name' => t('Azerbaijani Manat'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Qəpik'),
      'major_unit' => t('New Manat'),
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'BAM' => array(
      'code' => 'BAM',
      'numeric_code' => '977',
      'symbol' => 'KM',
      'name' => t('Bosnia-Herzegovina Convertible Mark'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Fening'),
      'major_unit' => t('Convertible Marka'),
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'BBD' => array(
      'code' => 'BBD',
      'numeric_code' => '052',
      'symbol' => '$',
      'name' => t('Barbadian Dollar'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'BDT' => array(
      'code' => 'BDT',
      'numeric_code' => '050',
      'symbol' => '৳',
      'name' => t('Bangladeshi Taka'),
      'symbol_placement' => 'after',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Paisa'),
      'major_unit' => t('Taka'),
    ),
    'BGN' => array(
      'code' => 'BGN',
      'numeric_code' => '975',
      'symbol' => 'лв.',
      'name' => t('Bulgarian Lev'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Stotinka'),
      'major_unit' => t('Lev'),
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
    ),
    'BHD' => array(
      'code' => 'BHD',
      'numeric_code' => '048',
      'symbol' => 'د.ب.‏',
      'name' => t('Bahraini Dinar'),
      'minor_unit' => t('Fils'),
      'major_unit' => t('Dinar'),
      'decimals' => 3,
    ),
    'BIF' => array(
      'code' => 'BIF',
      'numeric_code' => '108',
      'symbol' => 'FBu',
      'name' => t('Burundian Franc'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centime'),
      'major_unit' => t('Franc'),
      'decimals' => 0,
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'BMD' => array(
      'code' => 'BMD',
      'numeric_code' => '060',
      'symbol' => '$',
      'name' => t('Bermudan Dollar'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'BND' => array(
      'code' => 'BND',
      'numeric_code' => '096',
      'symbol' => '$',
      'name' => t('Brunei Dollar'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Sen'),
      'major_unit' => t('Dollar'),
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'BOB' => array(
      'code' => 'BOB',
      'numeric_code' => '068',
      'symbol' => 'Bs',
      'name' => t('Bolivian Boliviano'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Bolivianos'),
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'BRL' => array(
      'code' => 'BRL',
      'numeric_code' => '986',
      'symbol' => 'R$',
      'name' => t('Brazilian Real'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Reais'),
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'BSD' => array(
      'code' => 'BSD',
      'numeric_code' => '044',
      'symbol' => '$',
      'name' => t('Bahamian Dollar'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'BTN' => array(
      'code' => 'BTN',
      'numeric_code' => '064',
      'symbol' => 'Nu.',
      'name' => t('Bhutanese Ngultrum'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Chetrum'),
      'major_unit' => t('Ngultrum'),
    ),
    'BWP' => array(
      'code' => 'BWP',
      'numeric_code' => '072',
      'symbol' => 'P',
      'name' => t('Botswanan Pula'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Thebe'),
      'major_unit' => t('Pulas'),
    ),
    'BYN' => array(
      'code' => 'BYN',
      'numeric_code' => '933',
      'symbol' => 'Br',
      'name' => t('Belarusian Ruble'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Kopek'),
      'major_unit' => t('Ruble'),
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
    ),
    'BZD' => array(
      'code' => 'BZD',
      'numeric_code' => '084',
      'symbol' => '$',
      'name' => t('Belize Dollar'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'CAD' => array(
      'code' => 'CAD',
      'numeric_code' => '124',
      'symbol' => '$',
      'name' => t('Canadian Dollar'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'CDF' => array(
      'code' => 'CDF',
      'numeric_code' => '976',
      'symbol' => 'FC',
      'name' => t('Congolese Franc'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centime'),
      'major_unit' => t('Franc'),
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'CHF' => array(
      'code' => 'CHF',
      'numeric_code' => '756',
      'symbol' => 'CHF',
      'name' => t('Swiss Franc'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Rappen'),
      'major_unit' => t('Franc'),
      'thousands_separator' => '’',
      'rounding_step' => '0.05',
    ),
    'CLP' => array(
      'code' => 'CLP',
      'numeric_code' => '152',
      'symbol' => '$',
      'name' => t('Chilean Peso'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Peso'),
      'decimals' => 0,
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'CNY' => array(
      'code' => 'CNY',
      'numeric_code' => '156',
      'symbol' => '￥',
      'name' => t('Chinese Yuan'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Fen'),
      'major_unit' => t('Yuan'),
    ),
    'COP' => array(
      'code' => 'COP',
      'numeric_code' => '170',
      'symbol' => '$',
      'name' => t('Colombian Peso'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Peso'),
      'decimals' => 0,
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'CRC' => array(
      'code' => 'CRC',
      'numeric_code' => '188',
      'symbol' => '₡',
      'name' => t('Costa Rican Colón'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Céntimo'),
      'major_unit' => t('Colón'),
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
    ),
    'CUC' => array(
      'code' => 'CUC',
      'numeric_code' => '931',
      'symbol' => 'CUC',
      'name' => t('Cuban Convertible Peso'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Peso'),
    ),
    'CUP' => array(
      'code' => 'CUP',
      'numeric_code' => '192',
      'symbol' => '$',
      'name' => t('Cuban Peso'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Peso'),
    ),
    'CVE' => array(
      'code' => 'CVE',
      'numeric_code' => '132',
      'symbol' => '​',
      'name' => t('Cape Verdean Escudo'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Escudo'),
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
    ),
    'CZK' => array(
      'code' => 'CZK',
      'numeric_code' => '203',
      'symbol' => 'Kč',
      'name' => t('Czech Koruna'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Haléř'),
      'major_unit' => t('Koruna'),
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
    ),
    'DJF' => array(
      'code' => 'DJF',
      'numeric_code' => '262',
      'symbol' => 'DJF',
      'name' => t('Djiboutian Franc'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centime'),
      'major_unit' => t('Franc'),
      'decimals' => 0,
    ),
    'DKK' => array(
      'code' => 'DKK',
      'numeric_code' => '208',
      'symbol' => 'kr.',
      'name' => t('Danish Krone'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Øre'),
      'major_unit' => t('Kroner'),
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'DOP' => array(
      'code' => 'DOP',
      'numeric_code' => '214',
      'symbol' => 'RD$',
      'name' => t('Dominican Peso'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Peso'),
    ),
    'DZD' => array(
      'code' => 'DZD',
      'numeric_code' => '012',
      'symbol' => 'DZD',
      'name' => t('Algerian Dinar'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Santeem'),
      'major_unit' => t('Dinar'),
    ),
    'EGP' => array(
      'code' => 'EGP',
      'numeric_code' => '818',
      'symbol' => 'ج.م.‏',
      'name' => t('Egyptian Pound'),
      'minor_unit' => t('Piastr'),
      'major_unit' => t('Pound'),
    ),
    'ERN' => array(
      'code' => 'ERN',
      'numeric_code' => '232',
      'symbol' => 'Nfk',
      'name' => t('Eritrean Nakfa'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Nakfa'),
    ),
    'ETB' => array(
      'code' => 'ETB',
      'numeric_code' => '230',
      'symbol' => 'ETB',
      'name' => t('Ethiopian Birr'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Santim'),
      'major_unit' => t('Birr'),
    ),
    'EUR' => array(
      'code' => 'EUR',
      'numeric_code' => '978',
      'symbol' => '€',
      'name' => t('Euro'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Euro'),
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
    ),
    'FJD' => array(
      'code' => 'FJD',
      'numeric_code' => '242',
      'symbol' => '$',
      'name' => t('Fijian Dollar'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'FKP' => array(
      'code' => 'FKP',
      'numeric_code' => '238',
      'symbol' => '£',
      'name' => t('Falkland Islands Pound'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Penny'),
      'major_unit' => t('Pound'),
    ),
    'GBP' => array(
      'code' => 'GBP',
      'numeric_code' => '826',
      'symbol' => '£',
      'name' => t('British Pound'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Penny'),
      'major_unit' => t('Pound'),
    ),
    'GEL' => array(
      'code' => 'GEL',
      'numeric_code' => '981',
      'symbol' => '₾',
      'name' => t('Georgian Lari'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Tetri'),
      'major_unit' => t('Lari'),
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
    ),
    'GHS' => array(
      'code' => 'GHS',
      'numeric_code' => '936',
      'symbol' => 'GH₵',
      'name' => t('Ghanaian Cedi'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Pesewa'),
      'major_unit' => t('Cedi'),
    ),
    'GIP' => array(
      'code' => 'GIP',
      'numeric_code' => '292',
      'symbol' => '£',
      'name' => t('Gibraltar Pound'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Penny'),
      'major_unit' => t('Pound'),
    ),
    'GMD' => array(
      'code' => 'GMD',
      'numeric_code' => '270',
      'symbol' => 'D',
      'name' => t('Gambian Dalasi'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Butut'),
      'major_unit' => t('Dalasis'),
    ),
    'GNF' => array(
      'code' => 'GNF',
      'numeric_code' => '324',
      'symbol' => 'FG',
      'name' => t('Guinean Franc'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centime'),
      'major_unit' => t('Franc'),
      'decimals' => 0,
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
    ),
    'GTQ' => array(
      'code' => 'GTQ',
      'numeric_code' => '320',
      'symbol' => 'Q',
      'name' => t('Guatemalan Quetzal'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Quetzales'),
    ),
    'GYD' => array(
      'code' => 'GYD',
      'numeric_code' => '328',
      'symbol' => '$',
      'name' => t('Guyanaese Dollar'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
      'decimals' => 0,
    ),
    'HKD' => array(
      'code' => 'HKD',
      'numeric_code' => '344',
      'symbol' => 'HK$',
      'name' => t('Hong Kong Dollar'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'HNL' => array(
      'code' => 'HNL',
      'numeric_code' => '340',
      'symbol' => 'L',
      'name' => t('Honduran Lempira'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Lempiras'),
    ),
    'HRK' => array(
      'code' => 'HRK',
      'numeric_code' => '191',
      'symbol' => 'kn',
      'name' => t('Croatian Kuna'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Lipa'),
      'major_unit' => t('Kuna'),
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'HTG' => array(
      'code' => 'HTG',
      'numeric_code' => '332',
      'symbol' => 'HTG',
      'name' => t('Haitian Gourde'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centime'),
      'major_unit' => t('Gourde'),
    ),
    'HUF' => array(
      'code' => 'HUF',
      'numeric_code' => '348',
      'symbol' => 'Ft',
      'name' => t('Hungarian Forint'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'major_unit' => t('Forint'),
      'decimals' => 0,
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
    ),
    'IDR' => array(
      'code' => 'IDR',
      'numeric_code' => '360',
      'symbol' => 'Rp',
      'name' => t('Indonesian Rupiah'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Sen'),
      'major_unit' => t('Rupiahs'),
      'decimals' => 0,
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'ILS' => array(
      'code' => 'ILS',
      'numeric_code' => '376',
      'symbol' => '₪',
      'name' => t('Israeli New Shekel'),
      'symbol_placement' => 'after',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Agora'),
      'major_unit' => t('New Shekels'),
    ),
    'INR' => array(
      'code' => 'INR',
      'numeric_code' => '356',
      'symbol' => '₹',
      'name' => t('Indian Rupee'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Paisa'),
      'major_unit' => t('Rupee'),
    ),
    'IQD' => array(
      'code' => 'IQD',
      'numeric_code' => '368',
      'symbol' => 'د.ع.‏',
      'name' => t('Iraqi Dinar'),
      'minor_unit' => t('Fils'),
      'major_unit' => t('Dinar'),
      'decimals' => 0,
    ),
    'IRR' => array(
      'code' => 'IRR',
      'numeric_code' => '364',
      'symbol' => 'ریال',
      'name' => t('Iranian Rial'),
      'symbol_placement' => 'before',
      'symbol_spacer' => ',',
      'code_placement' => 'hidden',
      'minor_unit' => t('Rial'),
      'major_unit' => t('Toman'),
      'decimals' => 0,
    ),
    'ISK' => array(
      'code' => 'ISK',
      'numeric_code' => '352',
      'symbol' => 'ISK',
      'name' => t('Icelandic Króna'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Eyrir'),
      'major_unit' => t('Kronur'),
      'decimals' => 0,
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'JMD' => array(
      'code' => 'JMD',
      'numeric_code' => '388',
      'symbol' => '$',
      'name' => t('Jamaican Dollar'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'JOD' => array(
      'code' => 'JOD',
      'numeric_code' => '400',
      'symbol' => 'د.أ.‏',
      'name' => t('Jordanian Dinar'),
      'minor_unit' => t('Piastr'),
      'major_unit' => t('Dinar'),
      'decimals' => 3,
    ),
    'JPY' => array(
      'code' => 'JPY',
      'numeric_code' => '392',
      'symbol' => '￥',
      'name' => t('Japanese Yen'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Sen'),
      'major_unit' => t('Yen'),
      'decimals' => 0,
    ),
    'KES' => array(
      'code' => 'KES',
      'numeric_code' => '404',
      'symbol' => 'Ksh',
      'name' => t('Kenyan Shilling'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Shilling'),
    ),
    'KGS' => array(
      'code' => 'KGS',
      'numeric_code' => '417',
      'symbol' => 'сом',
      'name' => t('Kyrgystani Som'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Tyiyn'),
      'major_unit' => t('Som'),
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
    ),
    'KHR' => array(
      'code' => 'KHR',
      'numeric_code' => '116',
      'symbol' => '៛',
      'name' => t('Cambodian Riel'),
      'symbol_placement' => 'after',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Sen'),
      'major_unit' => t('Riel'),
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'KMF' => array(
      'code' => 'KMF',
      'numeric_code' => '174',
      'symbol' => 'ف.ج.ق.‏',
      'name' => t('Comorian Franc'),
      'minor_unit' => t('Centime'),
      'major_unit' => t('Franc'),
      'decimals' => 0,
    ),
    'KPW' => array(
      'code' => 'KPW',
      'numeric_code' => '408',
      'symbol' => 'KPW',
      'name' => t('North Korean Won'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Chon'),
      'major_unit' => t('Won'),
      'decimals' => 0,
    ),
    'KRW' => array(
      'code' => 'KRW',
      'numeric_code' => '410',
      'symbol' => '₩',
      'name' => t('South Korean Won'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Jeon'),
      'major_unit' => t('Won'),
      'decimals' => 0,
    ),
    'KWD' => array(
      'code' => 'KWD',
      'numeric_code' => '414',
      'symbol' => 'د.ك.‏',
      'name' => t('Kuwaiti Dinar'),
      'minor_unit' => t('Fils'),
      'major_unit' => t('Dinar'),
      'decimals' => 3,
    ),
    'KYD' => array(
      'code' => 'KYD',
      'numeric_code' => '136',
      'symbol' => '$',
      'name' => t('Cayman Islands Dollar'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'KZT' => array(
      'code' => 'KZT',
      'numeric_code' => '398',
      'symbol' => '₸',
      'name' => t('Kazakhstani Tenge'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Tiyn'),
      'major_unit' => t('Tenge'),
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
    ),
    'LAK' => array(
      'code' => 'LAK',
      'numeric_code' => '418',
      'symbol' => '₭',
      'name' => t('Laotian Kip'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Att'),
      'major_unit' => t('Kips'),
      'decimals' => 0,
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'LBP' => array(
      'code' => 'LBP',
      'numeric_code' => '422',
      'symbol' => 'ل.ل.‏',
      'name' => t('Lebanese Pound'),
      'minor_unit' => t('Piastre'),
      'major_unit' => t('Pound'),
      'decimals' => 0,
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'LKR' => array(
      'code' => 'LKR',
      'numeric_code' => '144',
      'symbol' => 'රු.',
      'name' => t('Sri Lankan Rupee'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Rupee'),
    ),
    'LRD' => array(
      'code' => 'LRD',
      'numeric_code' => '430',
      'symbol' => '$',
      'name' => t('Liberian Dollar'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'LSL' => array(
      'code' => 'LSL',
      'numeric_code' => '426',
      'symbol' => 'LSL',
      'name' => t('Lesotho Loti'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Sente'),
      'major_unit' => t('Loti'),
    ),
    'LYD' => array(
      'code' => 'LYD',
      'numeric_code' => '434',
      'symbol' => 'د.ل.‏',
      'name' => t('Libyan Dinar'),
      'minor_unit' => t('Dirham'),
      'major_unit' => t('Dinar'),
      'decimals' => 3,
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'MAD' => array(
      'code' => 'MAD',
      'numeric_code' => '504',
      'symbol' => 'د.م.‏',
      'name' => t('Moroccan Dirham'),
      'minor_unit' => t('Santimat'),
      'major_unit' => t('Dirhams'),
    ),
    'MDL' => array(
      'code' => 'MDL',
      'numeric_code' => '498',
      'symbol' => 'L',
      'name' => t('Moldovan Leu'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('bani'),
      'major_unit' => t('Lei'),
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'MGA' => array(
      'code' => 'MGA',
      'numeric_code' => '969',
      'symbol' => 'Ar',
      'name' => t('Malagasy Ariary'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'major_unit' => t('Ariary'),
      'decimals' => 0,
    ),
    'MKD' => array(
      'code' => 'MKD',
      'numeric_code' => '807',
      'symbol' => 'ден',
      'name' => t('Macedonian Denar'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Deni'),
      'major_unit' => t('Denari'),
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'MMK' => array(
      'code' => 'MMK',
      'numeric_code' => '104',
      'symbol' => 'K',
      'name' => t('Myanmar Kyat'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Pya'),
      'major_unit' => t('Kyat'),
      'decimals' => 0,
    ),
    'MNT' => array(
      'code' => 'MNT',
      'numeric_code' => '496',
      'symbol' => '₮',
      'name' => t('Mongolian Tugrik'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Möngö'),
      'major_unit' => t('Tugriks'),
      'decimals' => 0,
    ),
    'MOP' => array(
      'code' => 'MOP',
      'numeric_code' => '446',
      'symbol' => 'MOP$',
      'name' => t('Macanese Pataca'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Avo'),
      'major_unit' => t('Pataca'),
    ),
    'MRO' => array(
      'code' => 'MRO',
      'numeric_code' => '478',
      'symbol' => 'أ.م.‏',
      'name' => t('Mauritanian Ouguiya'),
      'minor_unit' => t('Khoums'),
      'major_unit' => t('Ouguiya'),
      'decimals' => 0,
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'MUR' => array(
      'code' => 'MUR',
      'numeric_code' => '480',
      'symbol' => 'Rs',
      'name' => t('Mauritian Rupee'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Rupee'),
      'decimals' => 0,
      'thousands_separator' => ' ',
    ),
    'MVR' => array(
      'code' => 'MVR',
      'numeric_code' => '462',
      'symbol' => 'MVR',
      'name' => t('Maldivian Rufiyaa'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Laari'), 
      'major_unit' => t('Rufiyaa'),
    ),
    'MWK' => array(
      'code' => 'MWK',
      'numeric_code' => '454',
      'symbol' => 'MK',
      'name' => t('Malawian Kwacha'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Tambala'),
      'major_unit' => t('Kwacha'),
    ),
    'MXN' => array(
      'code' => 'MXN',
      'numeric_code' => '484',
      'symbol' => '$',
      'name' => t('Mexican Peso'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Peso'),
    ),
    'MYR' => array(
      'code' => 'MYR',
      'numeric_code' => '458',
      'symbol' => 'RM',
      'name' => t('Malaysian Ringgit'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Sen'),
      'major_unit' => t('Ringgits'),
    ),
    'MZN' => array(
      'code' => 'MZN',
      'numeric_code' => '943',
      'symbol' => 'MTn',
      'name' => t('Mozambican Metical'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Metical'),
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
    ),
    'NAD' => array(
      'code' => 'NAD',
      'numeric_code' => '516',
      'symbol' => '$',
      'name' => t('Namibian Dollar'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
    ),
    'NGN' => array(
      'code' => 'NGN',
      'numeric_code' => '566',
      'symbol' => '₦',
      'name' => t('Nigerian Naira'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Kobo'),
      'major_unit' => t('Naira'),
    ),
    'NIO' => array(
      'code' => 'NIO',
      'numeric_code' => '558',
      'symbol' => 'C$',
      'name' => t('Nicaraguan Córdoba'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Cordoba'),
    ),
    'NOK' => array(
      'code' => 'NOK',
      'numeric_code' => '578',
      'symbol' => 'NOK',
      'name' => t('Norwegian Krone'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Øre'),
      'major_unit' => t('Krone'),
    ),
    'NPR' => array(
      'code' => 'NPR',
      'numeric_code' => '524',
      'symbol' => 'नेरू',
      'name' => t('Nepalese Rupee'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Paisa'),
      'major_unit' => t('Rupee'),
    ),
    'NZD' => array(
      'code' => 'NZD',
      'numeric_code' => '554',
      'symbol' => '$',
      'name' => t('New Zealand Dollar'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'OMR' => array(
      'code' => 'OMR',
      'numeric_code' => '512',
      'symbol' => 'ر.ع.‏',
      'name' => t('Omani Rial'),
      'minor_unit' => t('Baisa'),
      'major_unit' => t('Rial'),
      'decimals' => 3,
    ),
    'PAB' => array(
      'code' => 'PAB',
      'numeric_code' => '590',
      'symbol' => 'B/.',
      'name' => t('Panamanian Balboa'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centésimo'),
      'major_unit' => t('Balboa'),
    ),
    'PEN' => array(
      'code' => 'PEN',
      'numeric_code' => '604',
      'symbol' => 'S/',
      'name' => t('Peruvian Sol'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Céntimo'),
      'major_unit' => t('Nuevos Sole'),
    ),
    'PGK' => array(
      'code' => 'PGK',
      'numeric_code' => '598',
      'symbol' => 'PGK',
      'name' => t('Papua New Guinean Kina'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Toea'),
      'major_unit' => t('Kina '),
    ),
    'PHP' => array(
      'code' => 'PHP',
      'numeric_code' => '608',
      'symbol' => '₱',
      'name' => t('Philippine Peso'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Peso'),
    ),
    'PKR' => array(
      'code' => 'PKR',
      'numeric_code' => '586',
      'symbol' => 'Rs',
      'name' => t('Pakistani Rupee'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Paisa'),
      'major_unit' => t('Rupee'),
      'decimals' => 0,
    ),
    'PLN' => array(
      'code' => 'PLN',
      'numeric_code' => '985',
      'symbol' => 'zł',
      'name' => t('Polish Zloty'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Grosz'),
      'major_unit' => t('Złotych'),
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
    ),
    'PYG' => array(
      'code' => 'PYG',
      'numeric_code' => '600',
      'symbol' => 'PYG',
      'name' => t('Paraguayan Guarani'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Céntimo'),
      'major_unit' => t('Guarani'),
      'decimals' => 0,
    ),
    'QAR' => array(
      'code' => 'QAR',
      'numeric_code' => '634',
      'symbol' => 'ر.ق.‏',
      'name' => t('Qatari Rial'),
      'minor_unit' => t('Dirham'),
      'major_unit' => t('Rial'),
    ),
    'RON' => array(
      'code' => 'RON',
      'numeric_code' => '946',
      'symbol' => 'RON',
      'name' => t('Romanian Leu'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Ban'),
      'major_unit' => t('Leu'),
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'RSD' => array(
      'code' => 'RSD',
      'numeric_code' => '941',
      'symbol' => 'RSD',
      'name' => t('Serbian Dinar'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Para'),
      'major_unit' => t('Dinars'),
      'decimals' => 0,
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'RUB' => array(
      'code' => 'RUB',
      'numeric_code' => '643',
      'symbol' => '₽',
      'name' => t('Russian Ruble'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Kopek'),
      'major_unit' => t('Ruble'),
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
    ),
    'RWF' => array(
      'code' => 'RWF',
      'numeric_code' => '646',
      'symbol' => 'RF',
      'name' => t('Rwandan Franc'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centime'),
      'major_unit' => t('Franc'),
      'decimals' => 0,
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'SAR' => array(
      'code' => 'SAR',
      'numeric_code' => '682',
      'symbol' => 'ر.س.‏',
      'name' => t('Saudi Riyal'),
      'minor_unit' => t('Hallallah'),
      'major_unit' => t('Riyals'),
    ),
    'SBD' => array(
      'code' => 'SBD',
      'numeric_code' => '090',
      'symbol' => '$',
      'name' => t('Solomon Islands Dollar'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'SCR' => array(
      'code' => 'SCR',
      'numeric_code' => '690',
      'symbol' => 'SCR',
      'name' => t('Seychellois Rupee'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Rupee'),
    ),
    'SDG' => array(
      'code' => 'SDG',
      'numeric_code' => '938',
      'symbol' => 'ج.س.',
      'name' => t('Sudanese Pound'),
      'minor_unit' => t('Piastre'),
      'major_unit' => t('Pound'),
    ),
    'SEK' => array(
      'code' => 'SEK',
      'numeric_code' => '752',
      'symbol' => 'kr',
      'name' => t('Swedish Krona'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Öre'),
      'major_unit' => t('Kronor'),
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
    ),
    'SGD' => array(
      'code' => 'SGD',
      'numeric_code' => '702',
      'symbol' => '$',
      'name' => t('Singapore Dollar'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'SHP' => array(
      'code' => 'SHP',
      'numeric_code' => '654',
      'symbol' => 'SHP',
      'name' => t('St. Helena Pound'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Penny'),
      'major_unit' => t('Pound'),
    ),
    'SLL' => array(
      'code' => 'SLL',
      'numeric_code' => '694',
      'symbol' => 'SLL',
      'name' => t('Sierra Leonean Leone'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Leone'),
      'decimals' => 0,
    ),
    'SOS' => array(
      'code' => 'SOS',
      'numeric_code' => '706',
      'symbol' => 'S',
      'name' => t('Somali Shilling'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Shilling'),
      'decimals' => 0,
    ),
    'SRD' => array(
      'code' => 'SRD',
      'numeric_code' => '968',
      'symbol' => '$',
      'name' => t('Surinamese Dollar'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'SSP' => array(
      'code' => 'SSP',
      'numeric_code' => '728',
      'symbol' => '£',
      'name' => t('South Sudanese Pound'),
      'minor_unit' => t('Piaster'),
      'major_unit' => t('Pound'),
    ),
    'STD' => array(
      'code' => 'STD',
      'numeric_code' => '678',
      'symbol' => 'Db',
      'name' => t('São Tomé & Príncipe Dobra'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cêntimo'),
      'major_unit' => t('Dobra'),
      'decimals' => 0,
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
    ),
    'SYP' => array(
      'code' => 'SYP',
      'numeric_code' => '760',
      'symbol' => 'ل.س.‏',
      'name' => t('Syrian Pound'),
      'minor_unit' => t('Piastre'),
      'major_unit' => t('Pound'),
      'decimals' => 0,
    ),
    'SZL' => array(
      'code' => 'SZL',
      'numeric_code' => '748',
      'symbol' => 'E',
      'name' => t('Swazi Lilangeni'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Lilangeni'),
    ),
    'THB' => array(
      'code' => 'THB',
      'numeric_code' => '764',
      'symbol' => 'THB',
      'name' => t('Thai Baht'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Satang'),
      'major_unit' => t('Baht'),
    ),
    'TJS' => array(
      'code' => 'TJS',
      'numeric_code' => '972',
      'symbol' => 'TJS',
      'name' => t('Tajikistani Somoni'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Diram'),
      'major_unit' => t('Somoni'),
    ),
    'TMT' => array(
      'code' => 'TMT',
      'numeric_code' => '934',
      'symbol' => 'TMT',
      'name' => t('Turkmenistani Manat'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Tenge'),
      'major_unit' => t('Manat'),
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
    ),
    'TND' => array(
      'code' => 'TND',
      'numeric_code' => '788',
      'symbol' => 'TND',
      'name' => t('Tunisian Dinar'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Millime'),
      'major_unit' => t('Dinar'),
      'decimals' => 3,
    ),
    'TOP' => array(
      'code' => 'TOP',
      'numeric_code' => '776',
      'symbol' => 'T$',
      'name' => t('Tongan Paʻanga'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Senit'),
      'major_unit' => t('Paʻanga'),
    ),
    'TRY' => array(
      'code' => 'TRY',
      'numeric_code' => '949',
      'symbol' => '₺',
      'name' => t('Turkish Lira'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Kurus'),
      'major_unit' => t('Lira'),
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'TTD' => array(
      'code' => 'TTD',
      'numeric_code' => '780',
      'symbol' => '$',
      'name' => t('Trinidad & Tobago Dollar'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'TWD' => array(
      'code' => 'TWD',
      'numeric_code' => '901',
      'symbol' => '$',
      'name' => t('New Taiwan Dollar'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('New Dollar'),
    ),
    'TZS' => array(
      'code' => 'TZS',
      'numeric_code' => '834',
      'symbol' => 'TSh',
      'name' => t('Tanzanian Shilling'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Senti'),
      'major_unit' => t('Shilling'),
      'decimals' => 0,
    ),
    'UAH' => array(
      'code' => 'UAH',
      'numeric_code' => '980',
      'symbol' => '₴',
      'name' => t('Ukrainian Hryvnia'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Kopiyka'),
      'major_unit' => t('Hryvnia'),
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
    ),
    'UGX' => array(
      'code' => 'UGX',
      'numeric_code' => '800',
      'symbol' => 'USh',
      'name' => t('Ugandan Shilling'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Shilling'),
      'decimals' => 0,
    ),
    'USD' => array(
      'code' => 'USD',
      'numeric_code' => '840',
      'symbol' => '$',
      'name' => t('US Dollar'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'UYU' => array(
      'code' => 'UYU',
      'numeric_code' => '858',
      'symbol' => '$',
      'name' => t('Uruguayan Peso'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centésimo'),
      'major_unit' => t('Peso'),
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'UZS' => array(
      'code' => 'UZS',
      'numeric_code' => '860',
      'symbol' => 'soʻm',
      'name' => t('Uzbekistani Som'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Tiyin'),
      'major_unit' => t('Som'),
      'decimals' => 0,
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
    ),
    'VEF' => array(
      'code' => 'VEF',
      'numeric_code' => '937',
      'symbol' => 'Bs.',
      'name' => t('Venezuelan Bolívar'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Céntimo'),
      'major_unit' => t('Bolivares Fuerte'),
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'VND' => array(
      'code' => 'VND',
      'numeric_code' => '704',
      'symbol' => '₫',
      'name' => t('Vietnamese Dong'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Hà'),
      'major_unit' => t('Dong'),
      'decimals' => 0,
      'thousands_separator' => '.',
      'decimal_separator' => ',',
    ),
    'VUV' => array(
      'code' => 'VUV',
      'numeric_code' => '548',
      'symbol' => 'VUV',
      'name' => t('Vanuatu Vatu'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'major_unit' => t('Vatu'),
      'decimals' => 0,
    ),
    'WST' => array(
      'code' => 'WST',
      'numeric_code' => '882',
      'symbol' => 'WST',
      'name' => t('Samoan Tala'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Sene'),
      'major_unit' => t('Tala'),
    ),
    'XAF' => array(
      'code' => 'XAF',
      'numeric_code' => '950',
      'symbol' => 'FCFA',
      'name' => t('Central African CFA Franc'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centime'),
      'major_unit' => t('Franc'),
      'decimals' => 0,
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
    ),
    'XCD' => array(
      'code' => 'XCD',
      'numeric_code' => '951',
      'symbol' => '$',
      'name' => t('East Caribbean Dollar'),
      'symbol_placement' => 'before',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'XOF' => array(
      'code' => 'XOF',
      'numeric_code' => '952',
      'symbol' => 'CFA',
      'name' => t('West African CFA Franc'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centime'),
      'major_unit' => t('Franc'),
      'decimals' => 0,
    ),
    'XPF' => array(
      'code' => 'XPF',
      'numeric_code' => '953',
      'symbol' => 'FCFP',
      'name' => t('CFP Franc'),
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centime'),
      'major_unit' => t('Franc'),
      'decimals' => 0,
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
    ),
    'YER' => array(
      'code' => 'YER',
      'numeric_code' => '886',
      'symbol' => 'ر.ي.‏',
      'name' => t('Yemeni Rial'),
      'minor_unit' => t('Fils'),
      'major_unit' => t('Rial'),
      'decimals' => 0,
    ),
    'ZAR' => array(
      'code' => 'ZAR',
      'numeric_code' => '710',
      'symbol' => 'ZAR',
      'name' => t('South African Rand'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Rand'),
    ),
    'ZMW' => array(
      'code' => 'ZMW',
      'numeric_code' => '967',
      'symbol' => 'K',
      'name' => t('Zambian Kwacha'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Ngwee'),
      'major_unit' => t('Kwacha'),
    ),
  );
}
