/*! jRespond.js v 0.10 | Author: Jeremy Fields [jeremy.fields@viget.com], 2013 | License: MIT */

// Universal Module Definition
;(function (window, name, fn) {
	// Node module pattern
    if (typeof module === "object" && module && typeof module.exports === "object") {
        module.exports = fn;
    } else {
		// browser
        window[name] = fn;

        // AMD definition
        if (typeof define === "function" && define.amd) {
            define(name, [], function (module) {
                return fn;
            });
        }
    }
}(this, 'jRespond', function(win,doc,undefined) {

	'use strict';

	return function(breakpoints) {

		// array for registered functions
		var mediaListeners = [];

		// array that corresponds to mediaListeners and holds the current on/off state
		var mediaInit = [];

		// array of media query breakpoints; adjust as needed
		var mediaBreakpoints = breakpoints;

		// store the current breakpoint
		var curr = '';

		// the previous breakpoint
		var prev = '';

		// window resize event timer stuff
		var resizeTimer;
		var resizeW = 0;
		var resizeTmrFast = 100;
		var resizeTmrSlow = 500;
		var resizeTmrSpd = resizeTmrSlow;

		// cross browser window width
		var winWidth = function() {

			var w = 0;

			// IE
			if (typeof( window.innerWidth ) != 'number') {

				if (!(document.documentElement.clientWidth === 0)) {

					// strict mode
					w = document.documentElement.clientWidth;
				} else {

					// quirks mode
					w = document.body.clientWidth;
				}
			} else {

				// w3c
				w = window.innerWidth;
			}

			return w;
		};

		// determine input type
		var addFunction = function(elm) {
			if (elm.length === undefined) {
				addToStack(elm);
			} else {
				for (var i = 0; i < elm.length; i++) {
					addToStack(elm[i]);
				}
			}
		};

		// send media to the mediaListeners array
		var addToStack = function(elm) {
			var brkpt = elm['breakpoint'];
			var entr = elm['enter'] || undefined;

			// add function to stack
			mediaListeners.push(elm);

			// add corresponding entry to mediaInit
			mediaInit.push(false);

			if (testForCurr(brkpt)) {
				if (entr !== undefined) {
					entr.call(null, {entering : curr, exiting : prev});
				}
				mediaInit[(mediaListeners.length - 1)] = true;
			}
		};

		// loops through all registered functions and determines what should be fired
		var cycleThrough = function() {

			var enterArray = [];
			var exitArray = [];

			for (var i = 0; i < mediaListeners.length; i++) {
				var brkpt = mediaListeners[i]['breakpoint'];
				var entr = mediaListeners[i]['enter'] || undefined;
				var exit = mediaListeners[i]['exit'] || undefined;

				if (brkpt === '*') {
					if (entr !== undefined) {
						enterArray.push(entr);
					}
					if (exit !== undefined) {
						exitArray.push(exit);
					}
				} else if (testForCurr(brkpt)) {
					if (entr !== undefined && !mediaInit[i]) {
						enterArray.push(entr);
					}
					mediaInit[i] = true;
				} else {
					if (exit !== undefined && mediaInit[i]) {
						exitArray.push(exit);
					}
					mediaInit[i] = false;
				}
			}

			var eventObject = {
				entering : curr,
				exiting : prev
			};

			// loop through exit functions to call
			for (var j = 0; j < exitArray.length; j++) {
				exitArray[j].call(null, eventObject);
			}

			// then loop through enter functions to call
			for (var k = 0; k < enterArray.length; k++) {
				enterArray[k].call(null, eventObject);
			}
		};

		// checks for the correct breakpoint against the mediaBreakpoints list
		var returnBreakpoint = function(width) {

			var foundBrkpt = false;

			// look for existing breakpoint based on width
			for (var i = 0; i < mediaBreakpoints.length; i++) {

				// if registered breakpoint found, break out of loop
				if (width >= mediaBreakpoints[i]['enter'] && width <= mediaBreakpoints[i]['exit']) {
					foundBrkpt = true;

					break;
				}
			}

			// if breakpoint is found and it's not the current one
			if (foundBrkpt && curr !== mediaBreakpoints[i]['label']) {
				prev = curr;
				curr = mediaBreakpoints[i]['label'];

				// run the loop
				cycleThrough();

			// or if no breakpoint applies
			} else if (!foundBrkpt && curr !== '') {
				curr = '';

				// run the loop
				cycleThrough();
			}

		};

		// takes the breakpoint/s arguement from an object and tests it against the current state
		var testForCurr = function(elm) {

			// if there's an array of breakpoints
			if (typeof elm === 'object') {
				if (elm.join().indexOf(curr) >= 0) {
					return true;
				}

			// if the string is '*' then run at every breakpoint
			} else if (elm === '*') {
				return true;

			// or if it's a single breakpoint
			} else if (typeof elm === 'string') {
				if (curr === elm) {
					return true;
				}
			}
		};

		// self-calling function that checks the browser width and delegates if it detects a change
		var checkResize = function() {

			// get current width
			var w = winWidth();

			// if there is a change speed up the timer and fire the returnBreakpoint function
			if (w !== resizeW) {
				resizeTmrSpd = resizeTmrFast;

				returnBreakpoint(w);

			// otherwise keep on keepin' on
			} else {
				resizeTmrSpd = resizeTmrSlow;
			}

			resizeW = w;

			// calls itself on a setTimeout
			setTimeout(checkResize, resizeTmrSpd);
		};
		checkResize();

		// return
		return {
			addFunc: function(elm) { addFunction(elm); },
			getBreakpoint: function() { return curr; }
		};

	};

}(this,this.document)));;
(function($) {
'use strict';

// Define jRespond Media queries.
var jRes = jRespond([
  {
    label: 'mobile',
    enter: 0,
    exit: 480
  },{
    label: 'tablet',
    enter: 481,
    exit: 979
  },{
    label: 'desktop',
    enter: 980,
    exit: 9999
  }
]);

// Detect Operating system and add class to the body.
Drupal.behaviors.adminimal_os_class = {
  attach: function (context, settings) {
    // Detect if OS is mac based.
    if (navigator.userAgent.indexOf('Mac OS X') != -1) {
      $("body").addClass("mac");
    }
  }
};

// Modify the Search field for module filter.
Drupal.behaviors.adminimal_module_filter_box = {
  attach: function (context, settings) {
    //Add default hint value using the HTML5 placeholder attribute.
    $('input#edit-module-filter-name').attr( "placeholder", Drupal.t('Search') );
  }
};

// Fix some krumo styling.
Drupal.behaviors.krumo_remove_class = {
  attach: function (context, settings) {
    // Find status messages that has krumo div inside them, and change the classes.
    $('#console .messages.status').has("div.krumo-root").removeClass().addClass( "krumo-wrapper" );
  }
};

// Add media query classes to the body tag.
Drupal.behaviors.adminimal_media_queries = {
  attach: function (context, settings) {
    jRes.addFunc([
      {
        breakpoint: 'mobile',
          enter: function() {
            $( "body" ).addClass( "mq-mobile" );
          },
          exit: function() {
            $( "body" ).removeClass( "mq-mobile" );
          }
      },{
        breakpoint: 'tablet',
          enter: function() {
            $( "body" ).addClass( "mq-tablet" );
          },
          exit: function() {
            $( "body" ).removeClass( "mq-tablet" );
          }
      },{
        breakpoint: 'desktop',
          enter: function() {
            $( "body" ).addClass( "mq-desktop" );
          },
          exit: function() {
            $( "body" ).removeClass( "mq-desktop" );
          }
      }
    ]);
  }
};

// Move the active primary tab on mobile to be displayed last.
Drupal.behaviors.adminimal_move_active_primary_tab = {
  attach: function (context, settings) {
    // Add primary tabs class to the branding div for the bottom border.
    $('#branding').has("ul.tabs.primary").addClass( "has-primary-tabs" );

    // register enter and exit functions for a single breakpoint
    jRes.addFunc({
      breakpoint: 'mobile',
        enter: function() {
          $( "ul.tabs.primary li.active" ).clone().appendTo( "ul.tabs.primary" ).removeClass( "active" ).addClass( "current" );
          $( "ul.tabs.primary li.active" ).css("display", "none");
        },
        exit: function() {
          $( "ul.tabs.primary li.active" ).css("display", "table");
          $( "ul.tabs.primary li.current" ).css("display", "none");
        }
    });
  }
};

})(jQuery);
;

jQuery(document).ready(function($){


	jQuery('#resistance-program-with-exercise-node-form #edit-title-field').remove();


	jQuery('#generate-resistance-program-exercise-nodes').on('click',function(){
		

		//alert('hello');

/*

To submit a resistance program with exercise node: (not needed but a good baseline for the fields)
{"type":"resistance_program_with_exercise",
"title_field":{"und":[{"value":"Testing"}]},
"field_exercise_group_label_lette":{"und":"letter_r"},
"field_exercise_name_and_set_grou":{"und":[{"field_exercise_name":{"und":[{"value":"test exercise name one"}]}}]}}



Fields

#edit-field-resistance-program-und-0-tid

#edit-field-all-body-parts-und-0-tid

#edit-field-exercise-group-label-lette-und


table#field-exercise-name-and-set-grou-values

sub fields: (combine these texts and add the exercise description)

#edit-field-exercise-name-and-set-grou-und-0-field-exercise-name-und-0-value
#edit-field-exercise-name-and-set-grou-und-0-field-warm-up-set-und-0-value
#edit-field-exercise-name-and-set-grou-und-0-field-set-1-und-0-value
#edit-field-exercise-name-and-set-grou-und-0-field-set-2-und-0-value
#edit-field-exercise-name-and-set-grou-und-0-field-set-3-und-0-value
#edit-field-exercise-name-and-set-grou-und-0-field-set-4-und-0-value
#edit-field-exercise-name-and-set-grou-und-0-field-set-5-und-0-value



*/


		console.log('#edit-field-resistance-program-und-0-tid = '+jQuery('#edit-field-resistance-program-und-0-tid').val());

		console.log('#edit-field-all-body-parts-und-0-tid = '+jQuery('#edit-field-all-body-parts-und-0-tid').val());

		console.log('#edit-field-exercise-group-label-lette-und = '+jQuery('#edit-field-exercise-group-label-lette-und').val());

		console.log('#edit-field-resistance-program-und-0-tid = '+jQuery('#edit-field-resistance-program-und-0-tid').val());



		// lets count the number of exercises added 

		console.log('you adding this # of exercise = '+jQuery('.field-name-field-exercise-name').length);


		var numberOfExercisesBeingAdded = jQuery('.field-name-field-exercise-name').length;



			var allExerciseInputs = jQuery('.field-name-field-exercise-name input'),
				allWarmUpInputs = jQuery('.field-name-field-warm-up-set input'),
				allSet1Inputs = jQuery('.field-name-field-set-1 input'),
				allSet2Inputs = jQuery('.field-name-field-set-2 input'),
				allSet3Inputs = jQuery('.field-name-field-set-3 input'),
				allSet4Inputs = jQuery('.field-name-field-set-4 input'),
				allSet5Inputs = jQuery('.field-name-field-set-5 input');

		var jsonData = '';



		for (var ei = 0;ei < numberOfExercisesBeingAdded;ei++) {


			// Field collection sub fields 

			var thisExerciseName = jQuery(allExerciseInputs)[ei],
				thisWarmUp = jQuery(allWarmUpInputs)[ei],
				thisSet1 = jQuery(allSet1Inputs)[ei],
				thisSet2 = jQuery(allSet2Inputs)[ei],
				thisSet3 = jQuery(allSet3Inputs)[ei],
				thisSet4 = jQuery(allSet4Inputs)[ei],
				thisSet5 = jQuery(allSet5Inputs)[ei],
				combinedString = '';





			//console.log(jQuery(thisExerciseName).val());
			//console.log(jQuery(thisWarmUp).val());
			//console.log(jQuery(thisSet1).val());
			//console.log(jQuery(thisSet2).val());
			//console.log(jQuery(thisSet3).val());
			//console.log(jQuery(thisSet4).val());
			//console.log(jQuery(thisSet5).val());


			if (jQuery(thisWarmUp).val()){combinedString = combinedString+'warm up '+jQuery(thisWarmUp).val()+' repetitions    ';}
			if (jQuery(thisSet1).val()){combinedString = combinedString+'set 1 x '+jQuery(thisSet1).val()+' repetitions    ';}
			if (jQuery(thisSet2).val()){combinedString = combinedString+'set 2 x '+jQuery(thisSet2).val()+' repetitions    ';}
			if (jQuery(thisSet3).val()){combinedString = combinedString+'set 3 x '+jQuery(thisSet3).val()+' repetitions    ';}
			if (jQuery(thisSet4).val()){combinedString = combinedString+'set 4 x '+jQuery(thisSet4).val()+' repetitions    ';}
			if (jQuery(thisSet5).val()){combinedString = combinedString+'set 5 x '+jQuery(thisSet5).val()+' repetitions    ';}


			console.log('combinedString = '+combinedString);



			jsonData = '{"type":"exercise",'+
			'"title_field":{"und":[{"value":"'+jQuery(thisExerciseName).val()+'"}]},'+
			'"field_resistance_program":{"und":"'+jQuery('#edit-field-resistance-program-und-0-tid').val()+'"},'+
			'"field_all_body_parts":{"und":"'+jQuery('#edit-field-all-body-parts-und-0-tid').val()+'"},'+
			'"field_exercise_group_label_lette":{"und":"'+jQuery('#edit-field-exercise-group-label-lette-und').val()+'"},'+
			'"field_repetitions":{"und":[{"value":"'+combinedString+'"}]},'+
			'"field_order":{"und":[{"value":"'+(ei+1)+'"}]}'+
			'}';


			console.log(jsonData);


	        $.ajax({
	            url: '/api/node.json',
	            type: 'post',
	            contentType: 'application/json',
	            data: jsonData,
	            cache: false,
	            success: function(data, textStatus, jqXHR){
	                //alert(textStatus);
	                //console.log("success yo");
	   				//console.log(data);
	   				//create_meals(mealsPerDay,numberOfDays,data,allergies,dietary_restrictions,dietary_program,daily_caloric_intake,daily_protein_intake,daily_carb_intake,daily_fat_intake);
	            
	            },
	            error: function(data, textStatus, jqXHR){
	                //alert(textStatus);

	                console.log("exercise create API error");

	                console.log(data);

	            },
	            always: function(data){

	            	//jQuery('#validation-message').addClass('hide');

	            }
	        });






		} // END for

		setTimeout(function() { 
			//window.location.replace('/admin/content/resistance');
			alert('Saved.')
		}, 4000);

	}) // End Click Generate Exercises


});;
