<?php

$client_uid = arg(1); 
$user = user_load(intval($client_uid));
$fname = $user->field_first_name[LANGUAGE_NONE][0]['value'];
$lname = $user->field_last_name[LANGUAGE_NONE][0]['value'];

$apmhr = $user->field_age_pred_max_heart_rate[LANGUAGE_NONE][0]['value'];
$max_heart_rate_stress_test = $user->field_maximum_heart_rate_bpm[LANGUAGE_NONE][0]['value'];
$resting = $user->field_resting_heart_rate_bpm[LANGUAGE_NONE][0]['value'];
$vo2 = $user->field_vo2_maximum_ml_kg_min[LANGUAGE_NONE][0]['value'];



// Dietary Program - overrides for muscle 
$dietary_program = $user->field_10_select_dietary_program[LANGUAGE_NONE][0]['value'];
$field_protein_percentage = $user->field_protein_percentage	[LANGUAGE_NONE][0]['value'];
$field_carbohydrate_percent = $user->field_carbohydrate_percent[LANGUAGE_NONE][0]['value'];
$field_fat_percentage = $user->field_fat_percentage[LANGUAGE_NONE][0]['value'];



switch ($dietary_program) {

	case 'dietary_program_muscle_gain' :
		$dietary_program_text = 'Muscle Gain (bodybuilding offseason)';
	break;

	case 'dietary_program_body_building' :
		$dietary_program_text = 'Bodybuilding (contest)';
	break;

	case 'dietary_program_active_weight_loss' :
		$dietary_program_text = 'Active Weight Loss';
	break;

	case 'dietary_program_general_weight_loss' :
		$dietary_program_text = 'General Weight Loss';
	break;

	case 'dietary_program_maintenance' :
		$dietary_program_text = 'Maintenance';
	break;

	case 'dietary_program_custom' :
		$dietary_program_text = 'Custom';
	break;

}


// Heart Disease and Blood Pressure
$target_heart_rate = $user->field_target_heart_rate[LANGUAGE_NONE][0]['value'];
$heart_disease = $user->field_6_heart_disease[LANGUAGE_NONE][0]['value'];
$blood_pressure_control = $user->field_7_blood_pressure_control[LANGUAGE_NONE][0]['value'];


// Body Weight
$bodyweight = $user->field_3_weight_lb[LANGUAGE_NONE][0]['value'];


// Target Heart Rate
$heart_rate_range = explode(' - ',$target_heart_rate);
$lower_target_heart_rate = $heart_rate_range[0];
$higher_target_heart_rate = $heart_rate_range[1];

// Max Heart Rate and VO2
if ($heart_disease == 'heart_disease_no') {
	// Age Predicted Max Heart Rate
	$max_heart_rate = $apmhr;

	$vo2_min = intval($vo2)*.5;
	$vo2_max = intval($vo2)*.7;

	$heart_rate_string = 'Age Predicted<br />Max Heart Rate';


}
if ($heart_disease == 'heart_disease_yes') {
	// Max Heart Rate Based on Yearly Stress Test
	$max_heart_rate = $max_heart_rate_stress_test;

	// Use 50% - 70% VO2 maximum to calculate exercise intensities for heart disease

	$vo2_min = intval($vo2)*.5;
	$vo2_max = intval($vo2)*.7;

	$heart_rate_string = 'Max Heart Rate';

}

?>

<div id="client-programs-list">
<div class="container">
<div class="row rows">
<div class="col columns col-xs-12 col-sm-4 col-md-4 col-lg-4">
	<h5 class="title">Meal Plan</h5>
	<div class="border-black">
		<h5 class="sub-title"><?php echo $dietary_program_text; ?></h5>
		<div class="border-red"></div>
		<div class="section">
			<div class="section-title">Protein</div>
			<span class="protein-amount"><?php echo $field_protein_percentage; ?></span>
		</div>
		<div class="section">
			<div class="section-title">Carbohydrate</div>
			<span class="carbohydrate-amount"><?php echo $field_carbohydrate_percent; ?></span>
		</div>
		<div class="section">
			<div class="section-title">Fat</div>
			<span class="fat-amount"><?php echo $field_fat_percentage; ?></span>
		</div>
	</div>
	<a class="btn btn-primary" href="/user/<?php echo $client_uid; ?>/meal-plan">Create Meal Plan</a>
</div>
<div class="col columns col-xs-12 col-sm-4 col-md-4 col-lg-4">
	<h5 class="title">Cardio</h5>
	<div class="border-black">
		<h5 class="sub-title"><?php echo $heart_rate_string; ?></h5>
		<div class="border-red"></div>
		<div class="section">
			<div class="section-title">Max Heart Rate:</div>
			<span class="protein-amount"><?php echo $max_heart_rate; ?> BPM</span>
		</div>
		<div class="section">
			<div class="section-title">Lower Target Heart Rate:</div>
			<span class="carbohydrate-amount"><?php echo $lower_target_heart_rate; ?> BPM</span>
		</div>
		<div class="section">
			<div class="section-title">Upper Target Heart Rate:</div>
			<span class="fat-amount"><?php echo $higher_target_heart_rate; ?> BPM</span>
		</div>
	</div>
	<a class="btn btn-primary" href="/user/<?php echo $client_uid; ?>/cardio">View Cardio Program</a>
</div>
<div class="col columns col-xs-12 col-sm-4 col-md-4 col-lg-4">
	<h5 class="title">Resistance</h5>
	<div class="border-black">
		<h5 class="sub-title">TO DO: Weight Loss</h5>
		<div class="border-red"></div>
		<div class="section">
			<div class="section-title">TO DO: Total Body Circuit</div>
			<span class="protein-amount">TO DO: 2 or 3 Sets</span>
		</div>
	</div>
	<a class="btn btn-primary" href="/user/<?php echo $client_uid; ?>/resistance">Create Resistance Program</a>
</div>
</div>
</div>
</div>