<?php

// Variable Setup

$client_uid = arg(1); 
$user = user_load(intval($client_uid));
$fname = $user->field_first_name[LANGUAGE_NONE][0]['value'];
$lname = $user->field_last_name[LANGUAGE_NONE][0]['value'];

$dci = $user->field_daily_caloric_intake[LANGUAGE_NONE][0]['value'];

// Allergies
$allergies = $user->field_select_allergies[LANGUAGE_NONE];
for ($t = 0;$t < count($allergies);$t++) {
	$term = taxonomy_term_load($allergies[$t]['tid']);
  	$allergies_text .= $term->name.' - ';
  	//echo $term->name;
}

// Dietary Restrictions
$dietary_restrictions = $user->field_select_dietary_restriction[LANGUAGE_NONE];
for ($t = 0;$t < count($dietary_restrictions);$t++) {
	$term = taxonomy_term_load($dietary_restrictions[$t]['tid']);
  	$dietary_restrictions_text .= $term->name.' - ';
  	//echo $term->name;
}

// Dietary Program and get percentages of grams
$dietary_program = $user->field_10_select_dietary_program[LANGUAGE_NONE][0]['value'];
$protein_percent = 0.00;
$carbs_percent = 0.00;
$fats_percent = 0.00;
$dietary_program_label_1 = '';
$dietary_program_label_2 = '';
switch($dietary_program) {

	case 'dietary_program_muscle_gain' :
		$protein_percent = 0.30;
		$carbs_percent = 0.50;
		$fats_percent = 0.20;
		$dietary_program_label_1 = 'Dietary Program For '.$fname.' '.$lname;
		$dietary_program_label_2 = 'Muscle Gain (P'.($protein_percent*100).'% - C'.($carbs_percent*100).'% - F'.($fats_percent*100).'%)';
	break;

	case 'dietary_program_body_building' :
		$protein_percent = 0.50;
		$carbs_percent = 0.30;
		$fats_percent = 0.20;
		$dietary_program_label_1 = 'Dietary Program For '.$fname.' '.$lname;
		$dietary_program_label_2 = ' - Body Building (P'.($protein_percent*100).'% - C'.($carbs_percent*100).'% - F'.($fats_percent*100).'%)';
	break;

	case 'dietary_program_active_weight_loss' :
		$protein_percent = 0.40;
		$carbs_percent = 0.30;
		$fats_percent = 0.30;
		$dietary_program_label_1 = 'Dietary Program For '.$fname.' '.$lname;
		$dietary_program_label_2 = ' - Active Weight Loss (P'.($protein_percent*100).'% - C'.($carbs_percent*100).'% - F'.($fats_percent*100).'%)';
	break;

	case 'dietary_program_general_weight_loss' :
		$protein_percent = 0.33;
		$carbs_percent = 0.33;
		$fats_percent = 0.33;
		$dietary_program_label_1 = 'Dietary Program For '.$fname.' '.$lname;
		$dietary_program_label_2 = ' - General Weight Loss (P'.($protein_percent*100).'% - C'.($carbs_percent*100).'% - F'.($fats_percent*100).'%)';
	break;

	case 'dietary_program_maintenance' :
		$protein_percent = 0.25;
		$carbs_percent = 0.375;
		$fats_percent = 0.375;
		$dietary_program_label_1 = 'Dietary Program For '.$fname.' '.$lname;
		$dietary_program_label_2 = ' - Maintenance (P'.($protein_percent*100).'% - C'.($carbs_percent*100).'% - F'.($fats_percent*100).'%)';
	break;

	case 'dietary_program_custom' :
		$protein_percent = intval($user->field_protein_percentage[LANGUAGE_NONE][0]['value'])/100;
		$carbs_percent = intval($user->field_carbohydrate_percent[LANGUAGE_NONE][0]['value'])/100;
		$fats_percent = intval($user->field_fat_percentage[LANGUAGE_NONE][0]['value'])/100;
		$dietary_program_label_1 = 'Dietary Program - Custom';
		$dietary_program_label_2 = '';
	break;

}

// Daily Caloric Gram Intake of each 
// Protein yields 4 calories per gram
$dci_protein_grams = $dci*$protein_percent/4;
// Protein yields 4 calories per gram
$dci_carbohydrate_grams = $dci*$carbs_percent/4;
// Fat yields 9 calories per gram
$dci_fat_grams = $dci*$fats_percent/9;

?>

<div id="meal-plan-node-form">
<h6 class="center-heading">Create A New Meal Plan</h6>
<div class="center">We suggest scheduling meals plans by the week or month.</div>
<?php


// Node Form
module_load_include('inc', 'node', 'node.pages');
$form = node_add('meal_plan');
print drupal_render($form);

?>
</div>


<div class="debud-switch text-center hide">

	<input type="checkbox" id="debug-toggle"/><span>&nbsp;&nbsp;Enable DEBUG | <span class="debug version-number hide">VERSION TUE FEB 22 12:35 AM</span></span>

</div>


<div class="debug hide">
<h4>DEBUG</h4>
uid = <?php echo $client_uid; ?><br />
Daily Caloric Intake = <div class="daily-caloric-intake"><?php echo $dci; ?></div><br />
Allergies = <div class="allergies"><?php echo $allergies_text; ?></div><br />
Dietary Restrictions = <div class="dietary-restrictions"><?php echo $dietary_restrictions_text; ?></div><br />
Dietary Program	= <div class="dietary-program"><?php echo $dietary_program; ?></div><br />
</div>
<pre>
<?php //print_r($dietary_restrictions); ?>
</pre>




<!--
<div class="container d-inline">
<div class="row rows">
	<div class="col columns col-xs-12 col-sm-3 col-md-3 col-lg-3 report-name">Meal Plan For <?php echo $fname; ?> <?php echo $lname; ?> </div>
	<div class="col columns col-xs-12 col-sm-2 col-md-2 col-lg-2 action-buttons">
		<a href="#" class="btn-o save-pdf">Save Image</a>
	</div>
	<div class="col columns col-xs-12 col-sm-2 col-md-2 col-lg-2 action-buttons">
		<a href="#" class="btn-o print" onclick="window.print();return false;">Print</a>
	</div>
	<div class="col columns col-xs-12 col-sm-2 col-md-2 col-lg-2 action-buttons">
		<a href="#" class="btn-o email-mealplan">Email</a>
	</div>
	<div class="col columns col-xs-12 col-sm-3 col-md-3 col-lg-3 action-buttons">
		<a href="/user/<?php echo $client_uid; ?>/meal-plan" class="btn-o save-pdf">Create New Meal Plan</a>
	</div></div>
</div>
-->


<div id="report-actions" class="container d-inline">
<div class="row rows">
  <div class="columns col-xs-12 col-sm-4 col-md-4 col-lg-4 action-buttons save-meal-download-full-wrapper hide">
    <a id="save" href="#save" class="btn-o save-meal-download-full">
      <span class="loading hide">
        <i class="fa fa-circle-notch fa-spin"></i>
      </span>
      <span class="checkbox hide">
        <i class="fa fa-check-circle"></i>
      </span>
      Download Full Report
    </a>
  </div>
  <div class="columns col-xs-12 col-sm-4 col-md-4 col-lg-4 save-meal-wrapper action-buttons">
    <a id="save" href="#save" class="btn-o save-meal">
      <span class="loading hide">
        <i class="fa fa-circle-notch fa-spin"></i>
      </span>
      <span class="checkbox hide">
        <i class="fa fa-check-circle"></i>
      </span>
      Save And Continue
    </a>
  </div>
  <div class="columns col-xs-12 col-sm-4 col-md-4 col-lg-4 action-buttons">
    <a id="print" href="#print" class="btn-o print" onclick="window.print();return false;">
      <span class="loading hide">
        <i class="fa fa-circle-notch fa-spin"></i>
      </span>
      <span class="checkbox hide">
        <i class="fa fa-check-circle"></i>
      </span>
    Print</a>
  </div>
  <div class="columns col-xs-12 col-sm-4 col-md-4 col-lg-4 action-buttons">
    <a id="email" href="#email" class="btn-o email-meal email-action">
      <span class="loading hide">
        <i class="fa fa-circle-notch fa-spin"></i>
      </span>
      <span class="checkbox hide">
        <i class="fa fa-check-circle"></i>
      </span>
    Email
    </a>
  </div>
  <!--<div class="col columns col-xs-12 col-sm-3 col-md-3 col-lg-3 action-buttons">
    <a class="btn-o" href="/user/<?php echo $client_uid; ?>/meal-plan" id="save-pdf">Create Meal Plan</a>
  </div>-->
</div>
</div>






<div class="printthis-wrapper">
<div id="printthis">
<div id="meal-plan-table">



			<?php
				// Any Special Diet
				$dietary_restrictions_text = str_replace('-','',$dietary_restrictions_text);

				if ($dietary_restrictions_text != '') { echo 'Diet: '.$dietary_restrictions_text.' <br/>';}
			?>
			<?php
				// Any Allergies
				$allergies_text = str_replace('-','',$allergies_text);

				if ($allergies_text != '') { echo 'Allergies: '.$allergies_text.' <br/>';}
			?>

<!-- User Meal Specifics -->
<div class="container d-inline black-background">
<div class="row rows">
	<div class="col columns col-xs-12 col-sm-12 col-md-12 col-lg-12 center">
		<div class="dietary-program-label"><span class="report-name"><?php echo $dietary_program_label_1; ?></span> <?php echo $dietary_program_label_2; ?></div>
		Daily Caloric Intake <span class="grams dci"><?php echo $dci; ?></span> | Grams of Daily Protein <span class="grams protein-grams"><?php echo number_format($dci_protein_grams,1); ?></span> | Grams of Daily Carbohydrate <span class="grams carb-grams"><?php echo number_format($dci_carbohydrate_grams,1); ?></span> | Grams of Daily Fat <span class="grams fat-grams"><?php echo number_format($dci_fat_grams,1); ?></span>

		<br />

		<span class="grams meals-per-day-label"></span>

		<br />

		<span class="grams protein-grams-per-meal"></span> grams of protein per meal  <?php //echo number_format($dci_protein_grams/,1); ?> | <span class="grams carb-grams-per-meal"></span> grams of carbohydrates per meal <?php //echo number_format($dci_carbohydrate_grams,1); ?> | <span class="grams fat-grams-per-meal"></span> grams of fat per meal <?php //echo number_format($dci_fat_grams,1); ?>


	</div>
</div>
</div>

<!-- Day Dropdown and Grocery List -->
<div class="container d-inline">
<div class="row rows">
	<div class="col columns col-xs-12 col-sm-6 col-md-6 col-lg-6 select-day-wrapper">
		Select Day:
		<select id="select-day" class="form-select"></select>
		<span class="refresh"></span>
	</div>
	<div class="col columns col-xs-12 col-sm-6 col-md-6 col-lg-6 text-right right">
		

	<!--
		<a id="generate-grocery-list" href="#meal-plan" class="btn btn-primary next">Generate Grocery List</a>
	-->


	</div>
</div>
</div>



<div id="meal-plan-tables" class="container d-inline">


<!--
<div class="row rows">
	<div class="col columns col-xs-12 col-sm-12 col-md-12 col-lg-12">
		Meal One | Date: 00/00/0000<span class="refresh"></span>
		<table class="table-tpn-style table-bordered table">
			<thead><tr>
				<td>Meal</td>
				<td class="center">Measure</td>
				<td class="center">Weight (G)</td>
				<td class="center">Protein (G)</td>
				<td class="center">Carbs (G)</td>
				<td class="center">Fat (G)</td>
				<td class="center">Sodium (G)</td>
				<td class="center">Sugar (G)</td>
				<td class="center">Refresh</td>
			</tr></thead>
			<tbody>
				<tr>
					<td>Food Item 1</td>
					<td class="center">0 oz.</td>
					<td class="center">000.0</td>
					<td class="center">00.0</td>
					<td class="center">0.0</td>
					<td class="center">00.0</td>
					<td class="center">000</td>
					<td class="center">00</td>
					<td class="center"><span class="refresh"></span></td>
				</tr>



			</tbody>
		</table>

	</div>
</div>
-->



</div>








</div>




</div>  <!-- END PRINT THIS -->
</div>






<div id="report-actions" class="container d-inline">
<div class="row rows">
  <div class="columns col-xs-12 col-sm-4 col-md-4 col-lg-4 action-buttons save-meal-download-full-wrapper hide">
    <a id="save" href="#save" class="btn-o save-meal-download-full">
      <span class="loading hide">
        <i class="fa fa-circle-notch fa-spin"></i>
      </span>
      <span class="checkbox hide">
        <i class="fa fa-check-circle"></i>
      </span>
      Download Full Report
    </a>
  </div>
  <div class="columns col-xs-12 col-sm-4 col-md-4 col-lg-4 save-meal-wrapper action-buttons">
    <a id="save" href="#save" class="btn-o save-meal">
      <span class="loading hide">
        <i class="fa fa-circle-notch fa-spin"></i>
      </span>
      <span class="checkbox hide">
        <i class="fa fa-check-circle"></i>
      </span>
      Save And Continue
    </a>
  </div>
  <div class="columns col-xs-12 col-sm-4 col-md-4 col-lg-4 action-buttons">
    <a id="print" href="#print" class="btn-o print" onclick="window.print();return false;">
      <span class="loading hide">
        <i class="fa fa-circle-notch fa-spin"></i>
      </span>
      <span class="checkbox hide">
        <i class="fa fa-check-circle"></i>
      </span>
    Print</a>
  </div>
  <div class="columns col-xs-12 col-sm-4 col-md-4 col-lg-4 action-buttons">
    <a id="email" href="#email" class="btn-o email-meal email-action">
      <span class="loading hide">
        <i class="fa fa-circle-notch fa-spin"></i>
      </span>
      <span class="checkbox hide">
        <i class="fa fa-check-circle"></i>
      </span>
    Email
    </a>
  </div>
  <!--<div class="col columns col-xs-12 col-sm-3 col-md-3 col-lg-3 action-buttons">
    <a class="btn-o" href="/user/<?php echo $client_uid; ?>/meal-plan" id="save-pdf">Create Meal Plan</a>
  </div>-->
</div>
</div>






<!--
<div class="container d-inline">
<div class="row rows">
	<div class="col columns col-xs-12 col-sm-3 col-md-3 col-lg-3">Meal Plan For <?php echo $fname; ?> <?php echo $lname; ?> </div>
	<div class="col columns col-xs-12 col-sm-2 col-md-2 col-lg-2 action-buttons">
		<a href="#" class="btn-o save-pdf">Save Image</a>
	</div>
	<div class="col columns col-xs-12 col-sm-2 col-md-2 col-lg-2 action-buttons">
		<a href="#" class="btn-o print" onclick="window.print();return false;">Print</a>
	</div>
	<div class="col columns col-xs-12 col-sm-2 col-md-2 col-lg-2 action-buttons">
		<a href="#" class="btn-o email-mealplan">Email</a>
	</div>
	<div class="col columns col-xs-12 col-sm-3 col-md-3 col-lg-3 action-buttons">
		<a href="/user/<?php echo $client_uid; ?>/meal-plan" class="btn-o save-pdf">Create New Meal Plan</a>
	</div>
</div>
</div>

-->