<?php

$client_uid = arg(1); 
$user = user_load(intval($client_uid));
$fname = $user->field_first_name[LANGUAGE_NONE][0]['value'];
$lname = $user->field_last_name[LANGUAGE_NONE][0]['value'];

$apmhr = $user->field_age_pred_max_heart_rate[LANGUAGE_NONE][0]['value'];
$max_heart_rate_stress_test = $user->field_maximum_heart_rate_bpm[LANGUAGE_NONE][0]['value'];
$resting = $user->field_resting_heart_rate_bpm[LANGUAGE_NONE][0]['value'];
$vo2 = $user->field_vo2_maximum_ml_kg_min[LANGUAGE_NONE][0]['value'];



// Dietary Program - overrides for muscle 
$dietary_program = $user->field_10_select_dietary_program[LANGUAGE_NONE][0]['value'];


// Heart Disease and Blood Pressure
$target_heart_rate = $user->field_target_heart_rate[LANGUAGE_NONE][0]['value'];
$heart_disease = $user->field_6_heart_disease[LANGUAGE_NONE][0]['value'];
$blood_pressure_control = $user->field_7_blood_pressure_control[LANGUAGE_NONE][0]['value'];


// Body Weight
$bodyweight = $user->field_3_weight_lb[LANGUAGE_NONE][0]['value'];


function meters_per_min($mph) {

	$mpm = $mph * 26.8;

	return $mpm;
}





// Target Heart Rate
$heart_rate_range = explode(' - ',$target_heart_rate);
$lower_target_heart_rate = $heart_rate_range[0];
$higher_target_heart_rate = $heart_rate_range[1];

// Max Heart Rate and VO2
if ($heart_disease == 'heart_disease_no') {
	// Age Predicted Max Heart Rate
	$max_heart_rate = $apmhr;

	$vo2_min = intval($vo2)*.5;
	$vo2_max = intval($vo2)*.7;


}
if ($heart_disease == 'heart_disease_yes') {
	// Max Heart Rate Based on Yearly Stress Test
	$max_heart_rate = $max_heart_rate_stress_test;

	// Use 50% - 70% VO2 maximum to calculate exercise intensities for heart disease

	$vo2_min = intval($vo2)*.5;
	$vo2_max = intval($vo2)*.7;

}
if ($blood_pressure_control == 'blood_pressure_no') {
	// Max Heart Rate Based on Yearly Stress Test
	//$max_heart_rate = $max_heart_rate_stress_test; ERROR


	$max_heart_rate = $apmhr;


	// Use 50% - 70% VO2 maximum to calculate exercise intensities for heart disease

	$vo2_min = intval($vo2)*.4;
	$vo2_max = intval($vo2)*.6;

}




// Treadmill with VO2

// Treadmill speed starts a 3.3mph and grade start 5%
$default_mph = 3.3;
$m_min = meters_per_min($default_mph);


// Determine grades needed to reach target heart rate 
// 20 = (.1*$m_min)+(1.8*$m_min*%grade)+3.5;  SOLVE FOR GRADE

//$vo2_min = (.1*$m_min)+(1.8*$m_min*%grade)+3.5;

// Determine Treadmill Low Grade with VO2 calc
$leftover_from_20 = $vo2_min-(.1*$m_min)-3.5;
//echo '$leftover_from_20 = '.$leftover_from_20.'<br />';
$two_of_three_vars = (1.8*$m_min);
//echo '$two_of_three_vars = '.$two_of_three_vars.'<br />';
$grade_vo2_min = $leftover_from_20/$two_of_three_vars;
//echo '$grade_vo2_min = '.$grade_vo2_min.'<br />';
$grade_vo2_min_rounded_percent = round($grade_vo2_min,2)*100;
//echo '$grade_vo2_min_rounded_percent = '.$grade_vo2_min_rounded_percent.'%<br />';

$grade_min_rounded_percent = $grade_vo2_min_rounded_percent;

// Determine Treadmill High Grade with VO2 calc
$leftover_from_20 = $vo2_max-(.1*$m_min)-3.5;
//echo '$leftover_from_20 = '.$leftover_from_20.'<br />';
$two_of_three_vars = (1.8*$m_min);
//echo '$two_of_three_vars = '.$two_of_three_vars.'<br />';
$grade_vo2_max = $leftover_from_20/$two_of_three_vars;
//echo '$grade_vo2_max = '.$grade_vo2_min.'<br />';
$grade_vo2_max_rounded_percent = round($grade_vo2_max,2)*100;
//echo '$grade_vo2_max_rounded_percent = '.$grade_vo2_max_rounded_percent.'%<br />';

$grade_max_rounded_percent = $grade_vo2_max_rounded_percent;



function weight_in_kg($lb){

	$kg = $lb/2.2;

	return $kg;
}



// Cycle Ergometry with V02

/*
2(kgm) + 3.5 ( body weight in kg)= ml/min.,  for this example the body weight is 100 kilograms
Again fifty percent VO2 equals 20 ml/kg/min.
20 ml/kg/min. x 100 kg = 2000 ml/min.

2000 ml/min. = 2 (kgm) + 3.5 (100)

2000 ml/min. = 2x + 350
1650 = 2x
825 = kgm
6 kgm = 1 watt .......therefore:
825 kgm divided by 6 equals 138 watts
*/


$kg = weight_in_kg($bodyweight);


$ml_minute_min = $vo2_min * $kg;
//echo '$ml_minute_min = '.$ml_minute_min.'<br />';
$two_of_three_vars = $ml_minute_min-(3.5*$kg);
$kgm = $two_of_three_vars/2;
$watts_min_cycle = round($kgm/6);
//echo '$watts_min_cycle = '.$watts_min_cycle.'<br />';


$ml_minute_min = $vo2_max * $kg;
//echo '$ml_minute_min = '.$ml_minute_min.'<br />';
$two_of_three_vars = $ml_minute_min-(3.5*$kg);
$kgm = $two_of_three_vars/2;
$watts_max_cycle = round($kgm/6);
//echo '$watts_max_cycle = '.$watts_max_cycle.'<br />';







// Arm Ergometry with VO2


$kg = weight_in_kg($bodyweight);


$ml_minute_min = $vo2_min * $kg;
//echo '$ml_minute_min = '.$ml_minute_min.'<br />';
$two_of_three_vars = $ml_minute_min-(3.5*$kg);
$kgm = $two_of_three_vars/3;
$watts_min_arm = round($kgm/6);
//echo '$watts_min_arm = '.$watts_min_arm.'<br />';


$ml_minute_min = $vo2_max * $kg;
//echo '$ml_minute_min = '.$ml_minute_min.'<br />';
$two_of_three_vars = $ml_minute_min-(3.5*$kg);
$kgm = $two_of_three_vars/3;
$watts_max_arm = round($kgm/6);
//echo '$watts_max_arm = '.$watts_max_arm.'<br />';



?>





<div class="debug hide">
<h4>DEBUG</h4>
uid = <?php echo $client_uid; ?><br />
APMHR = <?php echo $apmhr; ?><br />
max_heart_rate_stress_test = <?php echo $max_heart_rate_stress_test; ?><br />
resting = <?php echo $resting; ?><br />
VO2 Maximum (ml/kg/min)	= <?php echo $vo2; ?><br />
Dietary Program	= <?php echo $dietary_program; ?><br />
########### EXERCISE CALCULATION FIELDS ###########<br />
Heart Disease Diagnosed	= <?php echo $heart_disease; ?><br />
Blood Pressure Control 	= <?php echo $blood_pressure_control; ?><br />
Target Heart Rate = <?php echo $target_heart_rate; ?><br />


</div>



<!--
<div class="container d-inline">
<div class="row rows">
	<div class="col columns col-xs-12 col-sm-3 col-md-3 col-lg-3 report-name">Cardio Program For <br /><?php echo $fname; ?> <?php echo $lname; ?>
	</div>
	<div class="col columns col-xs-12 col-sm-2 col-md-2 col-lg-2 action-buttons">
		<a href="#" class="btn-o save-pdf">Save Image</a>
	</div>
	<div class="col columns col-xs-12 col-sm-2 col-md-2 col-lg-2 action-buttons">
		<a href="#" class="btn-o print" onclick="window.print();return false;">Print</a>
	</div>
	<div class="col columns col-xs-12 col-sm-2 col-md-2 col-lg-2 action-buttons">
		<a href="#" class="btn-o email-cardio">Email</a>
	</div>
	<div class="col columns col-xs-12 col-sm-3 col-md-3 col-lg-3 action-buttons">
		<a href="/user/<?php echo $client_uid; ?>/meal-plan" class="btn-o save-pdf">Create Meal Plan</a>
	</div>
</div>
</div>
-->





<div id="report-actions" class="container d-inline">
<div class="row rows">
  <div class="columns col-xs-12 col-sm-4 col-md-4 col-lg-4 action-buttons">
    <a id="save" href="#save" class="btn-o save-cardio">
      <span class="loading hide">
        <i class="fa fa-circle-notch fa-spin"></i>
      </span>
      <span class="checkbox hide">
        <i class="fa fa-check-circle"></i>
      </span>
      Save And Continue
    </a>
  </div>
  <div class="columns col-xs-12 col-sm-4 col-md-4 col-lg-4 action-buttons">
    <a id="print" href="#print" class="btn-o print" onclick="window.print();return false;">
      <span class="loading hide">
        <i class="fa fa-circle-notch fa-spin"></i>
      </span>
      <span class="checkbox hide">
        <i class="fa fa-check-circle"></i>
      </span>
    Print</a>
  </div>
  <div class="columns col-xs-12 col-sm-4 col-md-4 col-lg-4 action-buttons">
    <a id="email" href="#email" class="btn-o email-cardio email-action">
      <span class="loading hide">
        <i class="fa fa-circle-notch fa-spin"></i>
      </span>
      <span class="checkbox hide">
        <i class="fa fa-check-circle"></i>
      </span>
    Email
    </a>
  </div>
  <!--<div class="col columns col-xs-12 col-sm-3 col-md-3 col-lg-3 action-buttons">
    <a class="btn-o" href="/user/<?php echo $client_uid; ?>/meal-plan" id="save-pdf">Create Meal Plan</a>
  </div>-->
</div>
</div>



<div class="printthis-wrapper">

<div id="printthis">



  <div class="report-header">
    <div class="logo">
      <img src="/sites/all/themes/tpnperfectbodies/images/logo.png">
    </div>
    <div class="eval-title report-name">Cardio Program For <?php echo $fname; ?> <?php echo $lname; ?></div>
  </div>





<div id="cardio-program">






<div class="container d-inline">
<div class="row rows">
	<div class="col columns col-xs-12 col-sm-12 col-md-12 col-lg-12">

		<table class="table-tpn-style table-bordered table">
			<thead><tr><td>EXERCISE Equipment</td><td class="center">Intensity</td><td class="center">Target heart rate</td></tr></thead>
			<tbody>


				<tr>
					<td>Treadmill Speed (mph)

						<select id="treadmill-speed">
							<option val="1.5">1.5</option>
							<option val="1.6">1.6</option>
							<option val="1.7">1.7</option>
							<option val="1.8">1.8</option>
							<option val="1.9">1.9</option>
							<option val="2.0">2.0</option>
							<option val="2.1">2.1</option>
							<option val="2.2">2.2</option>
							<option val="2.3">2.3</option>
							<option val="2.4">2.4</option>
							<option val="2.5">2.5</option>
							<option val="2.6">2.6</option>
							<option val="2.7">2.7</option>
							<option val="2.8">2.8</option>
							<option val="2.9">2.9</option>
							<option val="3.0">3.0</option>
							<option val="3.1">3.1</option>
							<option val="3.2">3.2</option>
							<option selected="selected" val="3.3">3.3</option>
							<option val="3.4">3.4</option>
							<option val="3.5">3.5</option>
							<option val="3.6">3.6</option>
							<option val="3.7">3.7</option>
							<option val="3.8">3.8</option>
							<option val="3.9">3.9</option>
							<option val="4">4</option>
							<option val="4.1">4.1</option>
							<option val="4.2">4.2</option>
							<option val="4.3">4.3</option>
							<option val="4.4">4.4</option>
							<option val="4.5">4.5</option>
							<option val="4.6">4.6</option>
							<option val="4.7">4.7</option>
							<option val="4.8">4.8</option>
							<option val="4.9">4.9</option>
							<option val="5">5</option>
						</select>

					</td>
					<td class="center treadmill-grade">Grade:

						<?php echo $grade_min_rounded_percent; ?>% -

						<?php echo $grade_max_rounded_percent; ?>%

					</td>
					<td class="center"><?php echo round($target_heart_rate); ?> bpm</td>
				</tr>
				


				<tr><td>Cycle</td><td class="center"><?php echo $watts_min_cycle; ?> to <?php echo $watts_max_cycle; ?> watts</td><td class="center"><?php echo round($target_heart_rate); ?> bpm</td></tr>
				

				<tr><td>Arm Ergometry</td><td class="center"><?php echo $watts_min_arm; ?> to <?php echo $watts_max_arm; ?> watts </td><td class="center"><?php echo round($target_heart_rate); ?> bpm</td></tr>


			</tbody>
		</table>

	</div>
</div>
</div>




<div class="container d-inline">
<div class="row rows">
	<div class="col columns col-xs-12 col-sm-12 col-md-12 col-lg-12">

		<?php if ($dietary_program == 'dietary_program_muscle_gain') { ?>
			<!-- Muscle Gain do not exercise as much -->
			<span class="cardio-session uppercase center">20 to 30 minutes per session | 1 session per day | 3 to 5 days per week (Muscle Gain)</span>

		<?php } else { ?>

			<span class="cardio-session uppercase center">30 to 60 minutes per session  |  1 to 2 sessions per day  |  3 to 5 days per week</span>

		<?php } ?>

	</div>
</div>
</div>




<div class="red-background">
<div class="row rows">
	<div class="col columns col-xs-12 col-sm-12 col-md-12 col-lg-12">

		<div class="cardio-recommendations uppercase center">Max Heart Rate: <span class="bpm"><?php echo  round($max_heart_rate); ?> bpm</span>  |  target heart rate: <span class="bpm target-heart-rate-min"><?php echo round($lower_target_heart_rate); ?> bpm</span>  - <span class="bpm target-heart-rate-max"><?php echo  round($higher_target_heart_rate); ?> bpm</span>

			<!-- Calc Values -->
			<span class="hide age-predicted-maximum-heart-rate"><?php echo $apmhr; ?></span>
			<span class="hide maximum-heart-rate"><?php echo $max_heart_rate_stress_test; ?></span>
			<span class="hide resting-heart-rate"><?php echo $resting; ?></span>
			<span class="hide vo2"><?php echo $vo2; ?></span>
			<span class="hide heart-disease"><?php echo $heart_disease; ?></span>
			<span class="hide blood-pressure-control"><?php echo $blood_pressure_control; ?></span>
			<span class="hide bodyweight"><?php echo $bodyweight; ?></span>
		</div>

	</div>
</div>
</div>



</div>




</div> <!-- END PRINT THIS -->

</div>




<div id="report-actions" class="container d-inline">
<div class="row rows">
  <div class="columns col-xs-12 col-sm-4 col-md-4 col-lg-4 action-buttons">
    <a id="save" href="#save" class="btn-o save-cardio">
      <span class="loading hide">
        <i class="fa fa-circle-notch fa-spin"></i>
      </span>
      <span class="checkbox hide">
        <i class="fa fa-check-circle"></i>
      </span>
      Save And Continue
    </a>
  </div>
  <div class="columns col-xs-12 col-sm-4 col-md-4 col-lg-4 action-buttons">
    <a id="print" href="#print" class="btn-o print" onclick="window.print();return false;">
      <span class="loading hide">
        <i class="fa fa-circle-notch fa-spin"></i>
      </span>
      <span class="checkbox hide">
        <i class="fa fa-check-circle"></i>
      </span>
    Print</a>
  </div>
  <div class="columns col-xs-12 col-sm-4 col-md-4 col-lg-4 action-buttons">
    <a id="email" href="#email" class="btn-o email-cardio email-action">
      <span class="loading hide">
        <i class="fa fa-circle-notch fa-spin"></i>
      </span>
      <span class="checkbox hide">
        <i class="fa fa-check-circle"></i>
      </span>
    Email
    </a>
  </div>
  <!--<div class="col columns col-xs-12 col-sm-3 col-md-3 col-lg-3 action-buttons">
    <a class="btn-o" href="/user/<?php echo $client_uid; ?>/meal-plan" id="save-pdf">Create Meal Plan</a>
  </div>-->
</div>
</div>
