<?php
/**
 * @file
 * Default theme implementation to display a single Drupal page.
 *
 * The doctype, html, head and body tags are not in this template. Instead they
 * can be found in the html.tpl.php template in this directory.
 *
 * Available variables:
 *
 * General utility variables:
 * - $base_path: The base URL path of the Drupal installation. At the very
 *   least, this will always default to /.
 * - $directory: The directory the template is located in, e.g. modules/system
 *   or themes/bartik.
 * - $is_front: TRUE if the current page is the front page.
 * - $logged_in: TRUE if the user is registered and signed in.
 * - $is_admin: TRUE if the user has permission to access administration pages.
 *
 * Site identity:
 * - $front_page: The URL of the front page. Use this instead of $base_path,
 *   when linking to the front page. This includes the language domain or
 *   prefix.
 * - $logo: The path to the logo image, as defined in theme configuration.
 * - $site_name: The name of the site, empty when display has been disabled
 *   in theme settings.
 * - $site_slogan: The slogan of the site, empty when display has been disabled
 *   in theme settings.
 *
 * Navigation:
 * - $main_menu (array): An array containing the Main menu links for the
 *   site, if they have been configured.
 * - $secondary_menu (array): An array containing the Secondary menu links for
 *   the site, if they have been configured.
 * - $breadcrumb: The breadcrumb trail for the current page.
 *
 * Page content (in order of occurrence in the default page.tpl.php):
 * - $title_prefix (array): An array containing additional output populated by
 *   modules, intended to be displayed in front of the main title tag that
 *   appears in the template.
 * - $title: The page title, for use in the actual HTML content.
 * - $title_suffix (array): An array containing additional output populated by
 *   modules, intended to be displayed after the main title tag that appears in
 *   the template.
 * - $messages: HTML for status and error messages. Should be displayed
 *   prominently.
 * - $tabs (array): Tabs linking to any sub-pages beneath the current page
 *   (e.g., the view and edit tabs when displaying a node).
 * - $action_links (array): Actions local to the page, such as 'Add menu' on the
 *   menu administration interface.
 * - $feed_icons: A string of all feed icons for the current page.
 * - $node: The node object, if there is an automatically-loaded node
 *   associated with the page, and the node ID is the second argument
 *   in the page's path (e.g. node/12345 and node/12345/revisions, but not
 *   comment/reply/12345).
 *
 * Regions:
 * - $page['help']: Dynamic help text, mostly for admin pages.
 * - $page['highlighted']: Items for the highlighted content region.
 * - $page['content']: The main content of the current page.
 * - $page['sidebar_first']: Items for the first sidebar.
 * - $page['sidebar_second']: Items for the second sidebar.
 * - $page['header']: Items for the header region.
 * - $page['footer']: Items for the footer region.
 *
 * @see bootstrap_preprocess_page()
 * @see template_preprocess()
 * @see template_preprocess_page()
 * @see bootstrap_process_page()
 * @see template_process()
 * @see html.tpl.php
 *
 * @ingroup themeable
 */
?>

<div class="row">
	<div class="full-width-container container no-pad">

    <!-- Carousel -->
    <div id="myCarousel" class="hidden-sm hidden-xs carousel slide" data-ride="carousel">
        <!-- Indicators -->
        <ol class="carousel-indicators">
            <li data-target="#myCarousel" data-slide-to="0" class="active"></li>
            <li data-target="#myCarousel" data-slide-to="1"></li>
            <li data-target="#myCarousel" data-slide-to="2"></li>
            <li data-target="#myCarousel" data-slide-to="3"></li>
			<li data-target="#myCarousel" data-slide-to="4"></li>
		</ol>
		

		
        <div class="carousel-inner" role="listbox">
            <div class="item active">
                <img class="first-slide" src="data:image/gif;base64,R0lGODlhAQABAIAAAHd3dwAAACH5BAAAAAAALAAAAAABAAEAAAICRAEAOw==" alt="First slide">
                <div class="full-width-container carousel no-pad" style="overflow:hidden;">
						<div class="col-lg-8 col-md-8 col-sm-6 col-xs-12 no-pad">
							<img src="<?php echo path_to_theme(); ?>/img/slide1.jpg"class="img-responsive">
						</div>
						<div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 slideshow-right">
							<h2 class="headline-white">Expandable Shelf - For Home or Office</h2>
							<ul class="slideshow-menu">
								<li>Expands from 40 - 75</li>
								<li>No Cutting, Easy Install</li>
								<li>Hardware Included</li>
								<li>Lifetime Guaranty</li>
								<li>Made in USA Certified</li>
							</ul>
							<button class="btn-yellow"><a href="/products">Buy Now</a></button>
						</div>
                </div>
            </div>
			


            <div id="animated-slide" class="item">
                <!--<img class="second-slide" src="data:image/gif;base64,R0lGODlhAQABAIAAAHd3dwAAACH5BAAAAAAALAAAAAABAAEAAAICRAEAOw==" alt="First slide">-->
                <div class="full-width-container carousel no-pad" style="overflow:hidden;">
						<div class="col-lg-8 col-md-8 col-sm-6 col-xs-12 no-pad" style="height:100%">
							<div id="sliding-animation">
								<style>
									#animated-slide {
										background: url('/images/animated-slide-bg.jpg') top repeat-x;
									}
									#sliding-animation {
										height:100%;
										position:relative;
										margin-top:0px;
									}
									#sliding-animation div {
									}
									#sliding-animation .left,
									#sliding-animation .right {
										position:absolute;
										height:100%;
									}
									#sliding-animation img {
										
									}
									#sliding-animation .left {
										z-index:9;
										left:0px;
										top:0;
									}
									#sliding-animation .right {
										z-index:8;
										left:75px;
										top:0;									
									}
								</style>
								<div class="left">
									<img src="<?php echo path_to_theme(); ?>/img/slide2a-left.jpg" class="img-responsive">
								</div>
								<div class="right">
									<img src="<?php echo path_to_theme(); ?>/img/slide2a-right.jpg" class="img-responsive">
								</div>
								<script type="text/javascript">
								
									//alert('hi');
									
									jQuery(function($) {
										
												var animateOncePerSlide = 0;
										
												var current_poll_interval;
												
												function startCurrentPolling() {
												  current_poll_interval = setInterval(currentPoll, 100);
												}

												function collapse_shelf_animation() {
													
													startCurrentPolling();
													
													$('#animated-slide .right')
													.delay(750)
													.animate({
															  left: '75px'														  
														  },2500,
														  function() {
																
														  }
													);

												}
												
												function expand_shelf_animation() {
													
													$('#animated-slide .right').animate({
															  left: '360px'														  
														  },2500,
														  function() {
																animateOncePerSlide = 0;
																collapse_shelf_animation();
														  }
													  );

												}
												

												function currentPoll() {
												  if ( $('#animated-slide').hasClass('active') ) {
														if (animateOncePerSlide == 0) {
															//alert('ping');
															
															
															
															animateOncePerSlide = 1;
															
															expand_shelf_animation();
															
														}
													stopCurrentPolling();
												  }
												}
												function stopCurrentPolling() {
												  clearInterval(current_poll_interval);
												}
												
												startCurrentPolling();
												
									
									});
									
								</script>
							</div>
						</div>
						<div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 slideshow-right">
							<h2 class="headline-white">Expands to Fit</h2>
							<ul class="slideshow-menu">
								<li>Multiple Widths</li>
								<li>Expands from 40 - 75</li>
								<li>No Cutting, Easy Install</li>
								<li>Lifetime Guarantee</li>
								<li>Made in USA</li>
								<li>Hardware Included</li>
							</ul>
							<button class="btn-yellow"><a href="/products">Buy Now</a></button>
						</div>
                </div>
            </div>
			

            <div class="item">
                <img class="third-slide" src="data:image/gif;base64,R0lGODlhAQABAIAAAHd3dwAAACH5BAAAAAAALAAAAAABAAEAAAICRAEAOw==" alt="First slide">
                <div class="full-width-container carousel no-pad" style="overflow:hidden;">
						<div class="col-lg-8 col-md-8 col-sm-6 col-xs-12 no-pad">
							<img src="/images/slides/laundry-room.jpg"class="img-responsive">
						</div>
						<div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 slideshow-right">
							<h2 class="headline-white">Expandable Laundry Room Kit</h2>
							<ul class="slideshow-menu">
								<li>Includes 1 Shelf &amp; Hanging Rod &amp; 1 End Bracket(40” - 74”), and 1 Shelf &amp; 2 End Brackets (40” – 75”) </li>
								<li>NO Cutting – Easy Install</li>
								<li>Expandable High Strength STEEL TUBES</li>
								<li>Hardware Included </li>
								<li>Lifetime Guarantee &amp; Made in USA Certified</li>
							</ul>
							<button class="btn-yellow"><a href="/products">Buy Now</a></button>
						</div>
                </div>
            </div>


			
            <div class="item">
                <img class="fourth-slide" src="data:image/gif;base64,R0lGODlhAQABAIAAAHd3dwAAACH5BAAAAAAALAAAAAABAAEAAAICRAEAOw==" alt="First slide">
                <div class="full-width-container carousel no-pad" style="overflow:hidden;">
						<div class="col-lg-8 col-md-8 col-sm-6 col-xs-12 no-pad">
							<img src="/images/slides/closet-kit.jpg"class="img-responsive">
						</div>
						<div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 slideshow-right">
							<h2 class="headline-white">Expandable Walk In Closet Kit</h2>
							<ul class="slideshow-menu">
								<li>Best Value – Includes 5 Shelf &amp; Rod Units</li>
								<li>No Cutting – Easy Install</li>
								<li>Hardware Included </li>
								<li>Expandable High Strength STEEL TUBES</li>
								<li>Lifetime Guarantee</li>
								<li>Made in USA Certified</li>
							</ul>
							<button class="btn-yellow"><a href="/products">Buy Now</a></button>
						</div>
                </div>
            </div>			
			
	        <div class="item">
                <img class="fifth-slide" src="data:image/gif;base64,R0lGODlhAQABAIAAAHd3dwAAACH5BAAAAAAALAAAAAABAAEAAAICRAEAOw==" alt="First slide">
                <div class="full-width-container carousel no-pad" style="overflow:hidden;">
						<div class="col-lg-8 col-md-8 col-sm-6 col-xs-12 no-pad">
							<img src="/images/slides/reach-in.jpg"class="img-responsive">
						</div>
						<div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 slideshow-right">
							<h2 class="headline-white">Expandable Reach In Closet Kits</h2>
							<ul class="slideshow-menu">
								<li>Double Hanging with &amp; without Shelves</li>
								<li>No Cutting – Easy Install</li>
								<li>Hardware Included </li>
								<li>Lifetime Guarantee</li>
								<li>Made in USA Certified</li>
							</ul>
							<button class="btn-yellow"><a href="/products">Buy Now</a></button>
						</div>
                </div>
            </div>			
					
			
			

	        <div class="item">
                <img class="sixth-slide" src="data:image/gif;base64,R0lGODlhAQABAIAAAHd3dwAAACH5BAAAAAAALAAAAAABAAEAAAICRAEAOw==" alt="First slide">
                <div class="full-width-container carousel no-pad" style="overflow:hidden;">
						<div class="col-lg-8 col-md-8 col-sm-6 col-xs-12 no-pad">
							<img src="/images/slides/garage.jpg"class="img-responsive">
						</div>
						<div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 slideshow-right">
							<h2 class="headline-white">Expandable Garage Shelves</h2>
							<ul class="slideshow-menu">
								<li>Holds 250lbs/shelf without securing to a stud</li>
								<li>No Cutting – Easy Install</li>
								<li>Hardware Included </li>
								<li>Lifetime Guarantee</li>
								<li>Made in USA Certified</li>
							</ul>
							<button class="btn-yellow"><a href="/products">Buy Now</a></button>
						</div>
                </div>
            </div>						
			
			<!--
            <div class="item">
                <img class="second-slide" src="data:image/gif;base64,R0lGODlhAQABAIAAAHd3dwAAACH5BAAAAAAALAAAAAABAAEAAAICRAEAOw==" alt="First slide">
                <div class="full-width-container container carousel no-pad" style="overflow:hidden;">
						<div class="col-lg-8 no-pad">
							<img src="<?php echo path_to_theme(); ?>/img/slide1.jpg"class="img-responsive">
						</div>
						<div class="col-lg-4 slideshow-right">
							<h2 class="headline-white">Slide 2</h2>
							
							<button class="btn-yellow">Buy Now</button>
						</div>
                </div>
            </div>
            <div class="item">
                <img class="third-slide" src="data:image/gif;base64,R0lGODlhAQABAIAAAHd3dwAAACH5BAAAAAAALAAAAAABAAEAAAICRAEAOw==" alt="First slide">
                <div class="full-width-container container carousel no-pad" style="overflow:hidden;">
						<div class="col-lg-8 no-pad">
							<img src="<?php echo path_to_theme(); ?>/img/slide1.jpg"class="img-responsive">
						</div>
						<div class="col-lg-4 slideshow-right">
							<h2 class="headline-white">Slide 3</h2>

							<button class="btn-yellow">Buy Now</button>
						</div>
                </div>
            </div>
        </div>
		-->
		
		
        <a class="left carousel-control" href="#myCarousel" role="button" data-slide="prev">
            <span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
            <span class="sr-only">Previous</span>
        </a>
        <a class="right carousel-control" href="#myCarousel" role="button" data-slide="next">
            <span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
            <span class="sr-only">Next</span>
        </a>
    </div><!-- /.carousel -->
	
	</div>
</div>
	
	
<div class="row">
    <!-- Links -->
    <div class="full-width-container container full-body">
	
	
		<div class="col-lg-4">
	
			<div id="midnav" class="row center-block">
					<ul>
						<li>
							<a href="/closet-organizers" class=" text-center">Closet Organizers</a>
						</li>
					</ul>
					<ul>
						<li>
							<a href="/expandable-shelving" class=" text-center">Expandable Shelving</a>
						</li>
					</ul>
					<ul>
						<li>
							<a href="/garage-organizers" class=" text-center">Garage Organizers</a>
						</li>
					</ul>
					<ul>
						<li>
							<a href="/shoe-racks" class=" text-center">Shoe Racks</a>
						</li>
					</ul>
					<ul>
						<li>
							<a href="/accessories" class=" text-center">Accessories</a>
						</li>
					</ul>
			</div>
			<!-- End Nav -->
			
		</div>


		<div class="col-lg-8">

		
			<!-- Featured Products -->
			<div id="featured" class="container full-width-container">
				<div class="row">
					<div id="headerlines" class="col-lg-3"></div><h3 class="text-center col-lg-6 headline">Featured Products</h3><div id="headerlines" class="col-lg-3"></div>
				</div>

				
				
					<!-- Insert Featured Products View -->
		
					<?php echo views_embed_view('front_page_featured_products', $display_id = 'featured_products_block'); ?>
		
				
				
	
			</div>
			
			
			
			
			
			
			
			
			
			
			
			
		</div>
	</div>
</div>


    <!-- Reviews -->
    <div id="reviews" class="full-width-container container" style="padding: 25px;margin-top:30px;">
        <div class="col-lg-6 col-md-6">
            <div class="embed-responsive embed-responsive-16by9">
                <iframe class="embed-responsive-item" src="https://www.youtube.com/embed/PmcWQKRjzSY" frameborder="0"></iframe>
            </div>
        </div>
        <div class="col-lg-6 col-md-6">
            <div class="row">
                <div id="headerlines-white" class="col-lg-4"></div><h3 class="text-center col-lg-4 headline" style="color:#fff;margin-bottom:10px;">Reviews</h3><div id="headerlines-white" class="col-lg-4"></div>
            </div>
            <p style="color:#fff;   padding: 0 25px 25px 25px;">I really like these closet shelves. They were a breeze to install! I was amazed at how much stuff I could store on them. Hangers slide like a breeze on this system. I would love to have these in all of my closets because they are so sturdy. I really like the fact that they are adjustable. I did not find one single thing that I didn't like about them!</p>
            <div class="row">
                <div id="stars" class="pull-left" style="width:270px;">
                    <span class="glyphicon glyphicon-star yellow" style="font-size: 30px" aria-hidden="true"></span>
                    <span class="glyphicon glyphicon-star yellow" style="font-size: 30px" aria-hidden="true"></span>
                    <span class="glyphicon glyphicon-star yellow" style="font-size: 30px" aria-hidden="true"></span>
                    <span class="glyphicon glyphicon-star yellow" style="font-size: 30px" aria-hidden="true"></span>
                    <span class="glyphicon glyphicon-star yellow" style="font-size: 30px" aria-hidden="true"></span>
                </div>
                <div class="pull-right">
                    <h5 style="color:#fff;font-weight: bold;text-align: right;">Matthew</h5>
                    <h5 style="color:#fff">WHITESBORO TX</h5>
                </div>
            </div>
        </div>
    </div>


	
	
    <!-- Blog -->

    <div id="blog" class="container">
        <div class="row">
            <div id="headerlines" class="col-lg-4"></div><h3 class="text-center col-lg-4 headline">EZ Shelf Blog</h3><div id="headerlines" class="col-lg-4"></div>
        </div>
		
		<!-- Insert Featured Blog View -->
		
		<?php echo views_embed_view('front_page_featured_blogs', $display_id = 'featured_blog_block'); ?>
		
    </div>
	
	
	

	
	
	    <!-- Enter To Win -->

    <div id="enter" class="full-width-container container" style="background-color: #1e1e1e;">
        <div class="row">
            <div id="headerlines" class="col-lg-3"></div><h1 class="text-center col-lg-6 headline" style="color: #fff;">Enter to Win a Free Closet Organizer</h1><div id="headerlines" class="col-lg-3"></div>
        </div>
        <!-- Entry Form -->
        <div class="row">
						<?php
							$blockObject = block_load('webform', 'client-block-295');
							$block = _block_get_renderable_array(_block_render_blocks(array($blockObject)));
							$output = drupal_render($block);
							print $output;

						?>
            <!--
            <a href="#">
                <div class="col-lg-3 col-md-3 col-xs-3" style="color: #ffffff; background-color: #6ba429;">
                    <h1 class="text-center">Submit</h1>
                </div>
            </a>
                -->
        </div>
    </div>

	

	
	
	
	
