<?php
/**
 * @file
 * Default theme implementation to display a single Drupal page.
 *
 * The doctype, html, head and body tags are not in this template. Instead they
 * can be found in the html.tpl.php template in this directory.
 *
 * Available variables:
 *
 * General utility variables:
 * - $base_path: The base URL path of the Drupal installation. At the very
 *   least, this will always default to /.
 * - $directory: The directory the template is located in, e.g. modules/system
 *   or themes/bartik.
 * - $is_front: TRUE if the current page is the front page.
 * - $logged_in: TRUE if the user is registered and signed in.
 * - $is_admin: TRUE if the user has permission to access administration pages.
 *
 * Site identity:
 * - $front_page: The URL of the front page. Use this instead of $base_path,
 *   when linking to the front page. This includes the language domain or
 *   prefix.
 * - $logo: The path to the logo image, as defined in theme configuration.
 * - $site_name: The name of the site, empty when display has been disabled
 *   in theme settings.
 * - $site_slogan: The slogan of the site, empty when display has been disabled
 *   in theme settings.
 *
 * Navigation:
 * - $main_menu (array): An array containing the Main menu links for the
 *   site, if they have been configured.
 * - $secondary_menu (array): An array containing the Secondary menu links for
 *   the site, if they have been configured.
 * - $breadcrumb: The breadcrumb trail for the current page.
 *
 * Page content (in order of occurrence in the default page.tpl.php):
 * - $title_prefix (array): An array containing additional output populated by
 *   modules, intended to be displayed in front of the main title tag that
 *   appears in the template.
 * - $title: The page title, for use in the actual HTML content.
 * - $title_suffix (array): An array containing additional output populated by
 *   modules, intended to be displayed after the main title tag that appears in
 *   the template.
 * - $messages: HTML for status and error messages. Should be displayed
 *   prominently.
 * - $tabs (array): Tabs linking to any sub-pages beneath the current page
 *   (e.g., the view and edit tabs when displaying a node).
 * - $action_links (array): Actions local to the page, such as 'Add menu' on the
 *   menu administration interface.
 * - $feed_icons: A string of all feed icons for the current page.
 * - $node: The node object, if there is an automatically-loaded node
 *   associated with the page, and the node ID is the second argument
 *   in the page's path (e.g. node/12345 and node/12345/revisions, but not
 *   comment/reply/12345).
 *
 * Regions:
 * - $page['help']: Dynamic help text, mostly for admin pages.
 * - $page['highlighted']: Items for the highlighted content region.
 * - $page['content']: The main content of the current page.
 * - $page['sidebar_first']: Items for the first sidebar.
 * - $page['sidebar_second']: Items for the second sidebar.
 * - $page['header']: Items for the header region.
 * - $page['footer']: Items for the footer region.
 *
 * @see bootstrap_preprocess_page()
 * @see template_preprocess()
 * @see template_preprocess_page()
 * @see bootstrap_process_page()
 * @see template_process()
 * @see html.tpl.php
 *
 * @ingroup themeable
 */
?>


<div class="container interior-header">
  <div class="full-width-container bg-green">
      <div class="row page-container">
        <div class="col-xs-12 col-sm-12 col-md-12">
            <?php print render($title_prefix); ?>
            <?php if (!empty($title)): ?>
              <h1 class="page-header"><?php print $title; ?></h1>
            <?php endif; ?>
        </div>
        <!--<div class="col-xs-12 col-sm-offset-0 col-sm-6 col-md-offset-2 col-md-4">
          <div id="search" class="">
            <?php
              //$search = module_invoke('search', 'block_view', 'form');
              //print render($search);
            ?>   
            <?php if (!empty($page['search'])): ?>
              <?php print render($page['search']); ?>
            <?php endif; ?>           
          </div>
        </div>-->
      </div>
  </div>
</div>


<div class="row">

  <div id="main" class="main-container container full-body page-container" role="main">

    <?php if (!empty($page['sidebar_first'])): ?>
      <aside class="col-sm-3" role="complementary">
        <?php print render($page['sidebar_first']); ?>
      </aside>  <!-- /#sidebar-first -->
    <?php endif; ?>

    <section class="main-section">
      <?php if (!empty($page['highlighted'])): ?>
        <div class="highlighted-region row"><?php print render($page['highlighted']); ?></div>
      <?php endif; ?>
      <a id="main-content"></a>
      <?php print render($title_suffix); ?>
      <?php print $messages; ?>
      <?php if (!empty($tabs)): ?>
        <?php print render($tabs); ?>
      <?php endif; ?>
      <?php if (!empty($page['help'])): ?>
        <?php print render($page['help']); ?>
      <?php endif; ?>
      <?php if (!empty($action_links)): ?>
        <ul class="action-links"><?php print render($action_links); ?></ul>
      <?php endif; ?>




<?php

 $node_wrapper = entity_metadata_wrapper('node', $node);

 // Fields
 $client_uid = $node_wrapper->field_client_uid->value();


 // Client Email

 $client = user_load($client_uid);

 $client_email = $client->mail;

?>

<!--
<ul class="tabs primary">
  <li><a href="/user/<?php echo $client_uid; ?>/evaluation">Evaluation</a></li>
  <li><a href="/user/<?php echo $client_uid; ?>/programs">Programs</a></li>
  <li><a href="/user/<?php echo $client_uid; ?>/meal-plan">Meal Plan</a></li>
  <li><a href="/user/<?php echo $client_uid; ?>/cardio">Cardio</a></li>
  <li><a href="/user/<?php echo $client_uid; ?>/resistance">Resistance</a></li>
</ul>
-->








<div id="report-actions" class="container d-inline">
<div class="row rows">

  <div class="columns col-xs-12 col-sm-4 col-md-4 col-lg-4 action-buttons">
    <a id="save" href="#save" class="btn-o save-evaluation">
      <span class="loading hide">
        <i class="fa fa-circle-notch fa-spin"></i>
      </span>
      <span class="checkbox hide">
        <i class="fa fa-check-circle"></i>
      </span>
      Save And Continue
    </a>
  </div>
  <div class="columns col-xs-12 col-sm-4 col-md-4 col-lg-4 action-buttons">
    <a id="print" href="#print" class="btn-o print" onclick="window.print();return false;">
      <span class="loading hide">
        <i class="fa fa-circle-notch fa-spin"></i>
      </span>
      <span class="checkbox hide">
        <i class="fa fa-check-circle"></i>
      </span>
    Print</a>
  </div>
  <div class="columns col-xs-12 col-sm-4 col-md-4 col-lg-4 action-buttons">
    <a id="email" href="#email" class="btn-o email-evaluation email-action">
      <span class="loading hide">
        <i class="fa fa-circle-notch fa-spin"></i>
      </span>
      <span class="checkbox hide">
        <i class="fa fa-check-circle"></i>
      </span>
    Email
    </a>
  </div>
  <!--<div class="col columns col-xs-12 col-sm-3 col-md-3 col-lg-3 action-buttons">
    <a class="btn-o" href="/user/<?php echo $client_uid; ?>/meal-plan" id="save-pdf">Create Meal Plan</a>
  </div>-->
</div>
</div>



<?php echo '<div class="evaluation-email">'.$client_email.'</div>'; ?>

  <div class="printthis-wrapper">

    <div id="printthis">


      <div class="report-header">
        <div class="logo">
          <img src="/sites/all/themes/tpnperfectbodies/images/logo.png">
        </div>
        <div class="eval-title report-name"><?php echo $title; ?> and Report</div>
      </div>



      <?php print render($page['content']); ?>

    </div>

  </div>




<div id="report-actions" class="container d-inline">
<div class="row rows">

  <div class="columns col-xs-12 col-sm-4 col-md-4 col-lg-4 action-buttons">
    <a id="save" href="#save" class="btn-o save-evaluation">
      <span class="loading hide">
        <i class="fa fa-circle-notch fa-spin"></i>
      </span>
      <span class="checkbox hide">
        <i class="fa fa-check-circle"></i>
      </span>
      Save And Continue
    </a>
  </div>
  <div class="columns col-xs-12 col-sm-4 col-md-4 col-lg-4 action-buttons">
    <a id="print" href="#print" class="btn-o print" onclick="window.print();return false;">
      <span class="loading hide">
        <i class="fa fa-circle-notch fa-spin"></i>
      </span>
      <span class="checkbox hide">
        <i class="fa fa-check-circle"></i>
      </span>
    Print</a>
  </div>
  <div class="columns col-xs-12 col-sm-4 col-md-4 col-lg-4 action-buttons">
    <a id="email" href="#email" class="btn-o email-evaluation email-action">
      <span class="loading hide">
        <i class="fa fa-circle-notch fa-spin"></i>
      </span>
      <span class="checkbox hide">
        <i class="fa fa-check-circle"></i>
      </span>
    Email
    </a>
  </div>
  <!--<div class="col columns col-xs-12 col-sm-3 col-md-3 col-lg-3 action-buttons">
    <a class="btn-o" href="/user/<?php echo $client_uid; ?>/meal-plan" id="save-pdf">Create Meal Plan</a>
  </div>-->
</div>
</div>



    </section>

    <?php if (!empty($page['sidebar_second'])): ?>
      <aside class="col-sm-3" role="complementary">
        <?php print render($page['sidebar_second']); ?>
      </aside>  <!-- /#sidebar-second -->
    <?php endif; ?>

  </div>
</div>


<?php print render($page['footer']); ?>
