<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<!--Bootstrap CSS-->
<link href="/sites/all/themes/tpnperfectbodies/css/bootstrap.min.css" rel="stylesheet">
<!--Font CSS-->
<link href="https://fonts.googleapis.com/css2?family=Lato:wght@100;300;400;700;900&display=swap" rel="stylesheet">
<!--Custom CSS-->
<link rel="stylesheet" media="print" href="/sites/all/themes/tpnperfectbodies/css/print.css" />
<link href="/sites/all/themes/tpnperfectbodies/css/style.css" rel="stylesheet">
<link rel="shortcut icon" type="image/png" href="/images/favicon.png"/>
<script src="https://www.dwin1.com/19038.js" type="text/javascript" defer="defer"></script>
<title><?php print $head_title; ?></title>
<?php print $head; ?>
<?php print $styles; ?>
<?php print $scripts; ?>
</head>
<?php 
	$thispage_user = user_load(arg(1));
	//echo $thispage_user->mail;
	$roles = implode(', ', $thispage_user->roles);
	$roles = str_replace('authenticated user,', '', $roles);

	global $user;
?>
<body class="<?php print $classes;?> <?php echo $roles; ?>" <?php print $attributes;?>>
<?php print $page_top; ?>
<div id="thisuser" class="hide">
	<span class="client-name"><?php echo $thispage_user->name; ?></span>
	<span class="client-uid"><?php echo $thispage_user->uid; ?></span>
	<span class="client-email"><?php echo $thispage_user->mail; ?></span>
	<span class="uid"><?php echo $user->uid; ?></span>
</div>
<div class="top-header">
    <div class="user-details">
        <?php 

        if (user_is_logged_in()){ ?>
            Logged in as: <?php 
            //echo print_r($user->roles);
            $roles = implode(', ', $user->roles);
            $roles = str_replace('authenticated user,', '', $roles);
            echo $user->mail;
            echo '<div class="membership-level"><a href="/user/'.$user->uid.'/edit">'.$roles.'</a></div>';
        } else {
            echo 'You are not logged in. <a href="/user/login">Login</a>';
        }
        ?></div>
</div>
<?php print $page_top; ?>

<header class="header">
<div class="header-content d-flex align-items-center">
<div class="container d-flex justify-content-between justify-content-lg-center">
<a href="/" class="logo"><img src="/sites/all/themes/tpnperfectbodies/images/logo.png" alt="" class="d-block"></a>
<div class="header-block d-lg-none d-flex align-items-center">
	<?php if (user_is_logged_in()) { ?>
		<a href="/user/logout" class="login-link">LOG OUT</a>
	<?php } else { ?>
		<a href="/user" class="login-link">LOG IN</a>
	<?php } ?>
<div class="nav-icon d-lg-none d-flex align-items-center"><span class="flex-grow-1"></span></div>
</div>
</div>
</div>
<!--<?php print render($main_menu); ?>-->
<nav class="menu d-lg-flex justify-content-center">
<div class="container-fluid">
<ul class="d-lg-flex align-items-center justify-content-between">
<li><a href="/">HOME</a></li>                 
<li><a href="/about-us">ABOUT US </a></li>                 
<li><a href="/programs">PROGRAMS </a></li>                 
<li><a href="/testimonials">TESTIMONIALS</a></li>   
<li><a href="/blog">BLOG</a></li>  
<li><a href="https://www.shareasale.com/shareasale.cfm?merchantID=81359">AFFILIATES</a>                
<li><a href="/contact">CONTACT </a></li>                 

	<?php if (user_is_logged_in()) { ?>
		<li><a href="/user/<?php echo $user->uid; ?>/edit">MY ACCOUNT</a></li>  
		<li class="d-none d-lg-block">
			<a href="/user/logout" class="login-link">LOG OUT</a>
		</li>
	<?php } else { ?>
		<li><a href="/programs">CREATE AN ACCOUNT</a></li>
		<li class="d-none d-lg-block">
			<a href="/user" class="login-link">LOG IN</a>
		</li>
	<?php } ?>
     
</ul>
</div>
</nav>
</header>


<?php print $page; ?>

 <footer class="footer">

<div class="footer-content">
<div class="container">
<div class="row rows">

<div class="col-lg-5 col-md-8 columns">

<div class="footer-row">
<a href="/" class="logo"><img src="/sites/all/themes/tpnperfectbodies/images/logo.png" alt="" class="d-block"></a>
</div>

<div class="footer-row">
<ul class="address">
<li><span><i class="fas fa-map-marker-alt"></i></span><h5>11031 Sospel Place<br/>Las Vegas  NV 89141</h5></li>
<li><span><i class="fas fa-phone"></i></span><h5>Phone: (570) 223- 4696</h5></li>
<li><span><i class="fas fa-envelope"></i></span><h5>E-mail: tpn.bodyperfect@gmail.com</h5></li>
</ul>
</div>


<!--
<div class="footer-row">
<div class="news-letter">
<h5 class="text-center">SUBSCRIBE TO OUR NEWSLETTER</h5>
<div class="news-letter-field">
<input type="text">
<label>email <span>*</span></label>
</div>
<div class="text-end">
<button type="submit" class="btn btn-primary news-letter-submit">SUBMIT</button>
</div>
</div>
</div>
-->

</div>

<div class="col-lg-7 columns">

<div class="footer-block">
<div class="footer-block-header">
<h4>Explore</h4>
</div>
<div class="footer-block-content">
<div class="row rows justify-content-between">
<div class="col-md-auto columns">
<ul class="footer-links">
<li><h5><a href="/">Home</a></h5></li>
<li><h5><a href="/about-us">About Us</a></h5></li>
<li><h5><a href="/programs">PRICING</a></h5></li>
</ul>
</div>
<div class="col-md-auto columns">
<ul class="footer-links">
<li><h5><a href="/programs">programs</a></h5></li>
<li><h5><a href="/testimonials">testimonials</a></h5></li>
<li><h5><a href="/demo">DEMO</a></h5></li>
</ul>
</div>
<div class="col-md-auto columns">
<ul class="footer-links">
<li><h5><a href="/contact">Contact</a></h5></li>
<li><h5><a href="/user/register">create an Account</a></h5></li>
<li><h5><a href="/terms-and-conditions-0">Terms and Conditions</a></h5></li>
<li><h5><a href="/blog">BLOG</a></h5></li>
<li><h5><a href="https://www.shareasale.com/shareasale.cfm?merchantID=81359">BECOME AN AFFILIATE</a></h5></li>
</ul>
</div>
</div>
</div>
</div>

<div class="footer-block">
<div class="footer-block-header">
<h4>FOLLOW US</h4>
</div>
<div class="footer-block-content">
<div class="social-media d-flex align-items-center justify-content-between">
<a target="_blank" href="https://www.facebook.com/tpnbodyperfect1/"><i class="fab fa-facebook-f"></i></a>
<a target="_blank" href="https://twitter.com/tpnbodyperfect"><i class="fab fa-twitter"></i></a>
<a target="_blank" href="https://www.instagram.com/tpn.bodyperfect/"><i class="fab fa-instagram"></i></a>
<a target="_blank" href="https://www.youtube.com/channel/UCW8k-AYkJ667rjsTfaoyD0g?sub_confirmation=1"><i class="fab fa-youtube"></i></a>
<a target="_blank" href="https://www.linkedin.com/in/mark-glusco-312b00ab/"><i class="fab fa-linkedin-in"></i></a>
</div>
</div>
</div>

</div>

</div>
</div>
</div>

<div class="copyright d-flex align-items-center">
<div class="container">
<h5 class="text-center">© <a href="/">Tailored Precision Nutrition</a> <?php echo date('Y'); ?> | <a href="https://www.graphicwebdesign.com" rel="nofollow" title="Web Application Development">Web Application Development by Graphic Web Design, Inc ®</a></h5>
</div>
</div>

</footer><!--//End Footer-->

<!--jQuery JS-->
<script src="/sites/all/themes/tpnperfectbodies/js/jquery-latest.min.js"></script>
<!--Fontawesome JS-->
<script src="/sites/all/themes/tpnperfectbodies/js/all.min.js"></script>
<!--Custom J
<script src="/sites/all/themes/tpnperfectbodies/js/html2canvas.js"></script>
S-->
<script src="https://unpkg.com/jspdf@latest/dist/jspdf.umd.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/html2canvas@1.0.0-rc.7/dist/html2canvas.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/jspdf-html2canvas@latest/dist/jspdf-html2canvas.min.js"></script>

<script type="module" src="/sites/all/themes/tpnperfectbodies/js/pdf-lib.min.js"></script>
<script src="/sites/all/themes/tpnperfectbodies/js/download.js"></script>


<!--

https://www.npmjs.com/package/jspdf-html2canvas

	
<script src="/sites/all/themes/tpnperfectbodies/js/jszip.js"></script>
-->
<script src="/sites/all/themes/tpnperfectbodies/js/custom.js"></script>
<?php print $page_bottom; ?>
<div class="region-popup region-popup-one hide">
  <div id="popup-one" class="popup-outer-wrapper">

		<div class="popup-full-wrapper">
		    <div id="report-popup" class="popup-wrapper">
		    		<div class="popup-close" data-popup-id="popup-one"><i class="fa fa-times-circle"></i></div>
		        <div class="popup-header">
		            <h2>Generate Report</h2>
		        </div>
		        <div class="popup-body">

		        	<pre>
		        	<?php 

		        	$user_data = user_load($user->uid);

		        	//var_dump($user_data);

		        	$reports_left = $user_data->field_report_count_this_term[LANGUAGE_NONE][0]['value']; ?>
		        	</pre>
		            <p>You currently have <span class="report-credits"><?php echo $reports_left; ?></span> report credits left for in this billing cycle.</p>

		            <p>You must save each portion of the report prior to downloading the <strong>Full Report</strong>. This will only deduct one report credit.</p>


		            <div class="report-list report-evaluation"><span class="checkbox">
		            	<i class="fa fa-check-square"></i></span>1. Evaluation Program Saved.</div>

		            <div class="report-list report-cardio"><span class="checkbox red">
		            	<i class="fas fa-times-circle"></i></span>2. You have not saved a cardio program yet.</div>

		            <div class="report-list report-mealplan"><span class="checkbox red">
		            	<i class="fas fa-times-circle"></i></span>3. You have not saved a meal plan yet.</div>

		            <div class="report-list report-resistance"><span class="checkbox red">
		            	<i class="fas fa-times-circle"></i></span>4. You have not saved a resistance program yet.</div>


		            <div class="report-next-step">
		            	<a class="btn btn-primary" href="#">Next Step</a>
		            </div>

		            <div class="generate-full-report hide">
		            	<a class="btn btn-primary download-full grey" href="#" disabled>
		            	   <span class="loading">
					        <i class="fa fa-circle-notch fa-spin"></i>
					      </span><span class="text">  Generating Report</span></a>
		            </div>



			        </div>

			    </div>
			</div>

		</div>
	</div>
</body>
</html>